/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.amqp.v100.mgmt;

import com.swiftmq.admin.mgmt.ConnectionHolder;
import com.swiftmq.admin.mgmt.Endpoint;
import com.swiftmq.admin.mgmt.ExceptionListener;
import com.swiftmq.admin.mgmt.RequestServiceFactory;
import com.swiftmq.amqp.AMQPContext;
import com.swiftmq.amqp.v100.client.Connection;
import com.swiftmq.amqp.v100.client.Consumer;
import com.swiftmq.amqp.v100.client.Producer;
import com.swiftmq.amqp.v100.client.Session;
import com.swiftmq.amqp.v100.generated.messaging.message_format.AddressIF;
import com.swiftmq.amqp.v100.generated.messaging.message_format.Data;
import com.swiftmq.amqp.v100.generated.messaging.message_format.Properties;
import com.swiftmq.amqp.v100.messaging.AMQPMessage;
import com.swiftmq.amqp.v100.mgmt.v400.EndpointImpl;
import com.swiftmq.amqp.v100.types.AMQPBinary;
import com.swiftmq.jms.ReconnectListener;
import com.swiftmq.mgmt.protocol.ProtocolFactory;
import com.swiftmq.mgmt.protocol.ProtocolReply;
import com.swiftmq.mgmt.protocol.ProtocolRequest;
import com.swiftmq.net.JSSESocketFactory;
import com.swiftmq.tools.dump.Dumpalizer;
import com.swiftmq.tools.requestreply.Reply;
import com.swiftmq.tools.requestreply.Request;
import com.swiftmq.tools.requestreply.RequestRegistry;
import com.swiftmq.tools.requestreply.RequestServiceRegistry;
import com.swiftmq.tools.requestreply.TimeoutException;
import com.swiftmq.tools.util.DataByteArrayInputStream;
import com.swiftmq.tools.util.DataByteArrayOutputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

public class AMQPConnectionHolder
implements ConnectionHolder {
    static final String MGMT_QUEUE = "swiftmqmgmt";
    static final int MGMT_PROTOCOL_VERSION = Integer.parseInt(System.getProperty("swiftmq.mgmt.protocol.version", "750"));
    static final String Q_MECHANISM = "mechanism";
    static final String Q_MAXFRAMESIZE = "maxframesize";
    static final String Q_IDLETIMEOUT = "idletimeout";
    Connection connection = null;
    String urlString = null;

    public AMQPConnectionHolder(Connection connection) {
        this.connection = connection;
    }

    public AMQPConnectionHolder(String urlString) {
        this.urlString = urlString;
    }

    private Map<String, String> getQueryMap(String query) {
        String[] params = query.split("&");
        HashMap<String, String> map = new HashMap<String, String>();
        for (String param : params) {
            String name = param.split("=")[0];
            String value = param.split("=")[1];
            map.put(name, value);
        }
        return map;
    }

    @Override
    public void connect(String username, String password) throws Exception {
        String query;
        int port;
        URL url = new URL(this.urlString.replaceFirst("amqp:", "http:").replaceFirst("amqps:", "https:"));
        String hostname = url.getHost();
        if (hostname == null) {
            hostname = "localhost";
        }
        if ((port = url.getPort()) == -1) {
            port = this.urlString.startsWith("amqps:") ? 5671 : 5672;
        }
        AMQPContext ctx = new AMQPContext(0);
        this.connection = username == null || username.trim().length() == 0 ? new Connection(ctx, hostname, port, true) : new Connection(ctx, hostname, port, username, password);
        if (this.urlString.startsWith("amqps:")) {
            this.connection.setSocketFactory(new JSSESocketFactory());
        }
        if ((query = url.getQuery()) != null) {
            Map<String, String> queryMap = this.getQueryMap(query);
            String v = queryMap.get(Q_MECHANISM);
            if (v != null) {
                this.connection.setMechanism(v);
            }
            if ((v = queryMap.get(Q_MAXFRAMESIZE)) != null) {
                this.connection.setMaxFrameSize(Long.parseLong(v));
            }
            if ((v = queryMap.get(Q_IDLETIMEOUT)) != null) {
                this.connection.setIdleTimeout(Long.parseLong(v));
            }
        }
        this.connection.connect();
    }

    @Override
    public void start() throws Exception {
    }

    @Override
    public void setExceptionListener(final ExceptionListener exceptionListener) throws Exception {
        this.connection.setExceptionListener(new com.swiftmq.amqp.v100.client.ExceptionListener(){

            @Override
            public void onException(Exception exception) {
                try {
                    exceptionListener.onException(exception);
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
        });
    }

    @Override
    public void addReconnectListener(ReconnectListener reconnectListener) {
    }

    @Override
    public void removeReconnectListener(ReconnectListener reconnectListener) {
    }

    @Override
    public Endpoint createEndpoint(String routerName, RequestServiceFactory requestServiceFactory, boolean createInternalCommands) throws Exception {
        return new EndpointCreator(routerName, this.connection).create(requestServiceFactory, createInternalCommands);
    }

    @Override
    public void close() {
        if (this.connection != null) {
            this.connection.close();
        }
    }

    private static class EndpointCreator {
        String routerName = null;
        Connection connection = null;
        Session session = null;
        Producer sender = null;
        Consumer receiver = null;
        AddressIF replyAddress = null;

        private EndpointCreator(String routerName, Connection connection) throws Exception {
            this.routerName = routerName;
            this.connection = connection;
            String queueName = null;
            queueName = routerName == null ? AMQPConnectionHolder.MGMT_QUEUE : "swiftmqmgmt@" + routerName;
            try {
                this.session = connection.createSession(100L, 100L);
                this.sender = this.session.createProducer(queueName, 0);
                this.receiver = this.session.createConsumer(100, 0);
                this.replyAddress = this.receiver.getRemoteAddress();
            }
            catch (Exception e) {
                this.cleanup();
                throw e;
            }
        }

        private AMQPMessage requestToMessage(Request request) throws Exception {
            DataByteArrayOutputStream dos = new DataByteArrayOutputStream();
            dos.rewind();
            Dumpalizer.dump(dos, request);
            AMQPMessage msg = new AMQPMessage();
            byte[] bytes = new byte[dos.getCount()];
            System.arraycopy(dos.getBuffer(), 0, bytes, 0, bytes.length);
            msg.addData(new Data(bytes));
            return msg;
        }

        private Reply messageToReply(AMQPMessage msg) throws Exception {
            Data data = msg.getData().get(0);
            DataByteArrayInputStream dis = new DataByteArrayInputStream(data.getValue());
            return (Reply)Dumpalizer.construct(dis, new ProtocolFactory());
        }

        private Reply request(Request request) throws Exception {
            AMQPMessage msg = this.requestToMessage(request);
            Properties prop = new Properties();
            if (this.connection.getUserName() == null) {
                prop.setUserId(new AMQPBinary("anonymous".getBytes()));
            } else {
                prop.setUserId(new AMQPBinary(this.connection.getUserName().getBytes()));
            }
            prop.setReplyTo(this.replyAddress);
            msg.setProperties(prop);
            this.sender.send(msg);
            msg = this.receiver.receive(RequestRegistry.SWIFTMQ_REQUEST_TIMEOUT);
            if (msg == null) {
                throw new TimeoutException("Request timeout occured (" + RequestRegistry.SWIFTMQ_REQUEST_TIMEOUT + ") ms");
            }
            return this.messageToReply(msg);
        }

        public Endpoint create(RequestServiceFactory rsf, boolean createInternalCommands) throws Exception {
            RequestServiceRegistry endpoint = null;
            try {
                switch (MGMT_PROTOCOL_VERSION) {
                    case 750: {
                        ProtocolReply pr = (ProtocolReply)this.request(new ProtocolRequest(750));
                        if (pr.isOk()) {
                            endpoint = new com.swiftmq.amqp.v100.mgmt.v750.EndpointImpl(this.connection, this.session, this.sender, this.receiver, this.replyAddress, rsf.createRequestService(750), createInternalCommands);
                            endpoint.setSubscriptionFilterEnabled(true);
                            break;
                        }
                        pr = (ProtocolReply)this.request(new ProtocolRequest(400));
                        if (!pr.isOk()) {
                            throw pr.getException();
                        }
                        endpoint = new EndpointImpl(this.connection, this.session, this.sender, this.receiver, this.replyAddress, rsf.createRequestService(400), createInternalCommands);
                        break;
                    }
                    case 400: {
                        ProtocolReply pr = (ProtocolReply)this.request(new ProtocolRequest(400));
                        if (!pr.isOk()) {
                            throw pr.getException();
                        }
                        endpoint = new EndpointImpl(this.connection, this.session, this.sender, this.receiver, this.replyAddress, rsf.createRequestService(400), createInternalCommands);
                        break;
                    }
                    default: {
                        throw new Exception("Invalid management protocol version (set via swiftmq.mgmt.protocol.version): " + MGMT_PROTOCOL_VERSION);
                    }
                }
            }
            catch (Exception e) {
                this.cleanup();
                throw e;
            }
            return endpoint;
        }

        private void cleanup() {
            if (this.session != null) {
                try {
                    this.session.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

