/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.amqp.v100.mgmt.v750;

import com.swiftmq.admin.mgmt.Endpoint;
import com.swiftmq.amqp.v100.client.Connection;
import com.swiftmq.amqp.v100.client.Consumer;
import com.swiftmq.amqp.v100.client.MessageAvailabilityListener;
import com.swiftmq.amqp.v100.client.Producer;
import com.swiftmq.amqp.v100.client.Session;
import com.swiftmq.amqp.v100.generated.messaging.message_format.AddressIF;
import com.swiftmq.amqp.v100.generated.messaging.message_format.Data;
import com.swiftmq.amqp.v100.generated.messaging.message_format.Properties;
import com.swiftmq.amqp.v100.messaging.AMQPMessage;
import com.swiftmq.amqp.v100.types.AMQPBinary;
import com.swiftmq.auth.ChallengeResponseFactory;
import com.swiftmq.mgmt.Command;
import com.swiftmq.mgmt.CommandExecutor;
import com.swiftmq.mgmt.CommandRegistry;
import com.swiftmq.mgmt.Entity;
import com.swiftmq.mgmt.protocol.ProtocolFactory;
import com.swiftmq.mgmt.protocol.v750.AuthReply;
import com.swiftmq.mgmt.protocol.v750.AuthRequest;
import com.swiftmq.mgmt.protocol.v750.CommandReply;
import com.swiftmq.mgmt.protocol.v750.CommandRequest;
import com.swiftmq.mgmt.protocol.v750.ConnectReply;
import com.swiftmq.mgmt.protocol.v750.ConnectRequest;
import com.swiftmq.mgmt.protocol.v750.LeaseRequest;
import com.swiftmq.mgmt.protocol.v750.RemoveSubscriptionFilterRequest;
import com.swiftmq.mgmt.protocol.v750.SetSubscriptionFilterRequest;
import com.swiftmq.tools.dump.Dumpable;
import com.swiftmq.tools.dump.Dumpalizer;
import com.swiftmq.tools.requestreply.Reply;
import com.swiftmq.tools.requestreply.Request;
import com.swiftmq.tools.requestreply.RequestHandler;
import com.swiftmq.tools.requestreply.RequestRegistry;
import com.swiftmq.tools.requestreply.RequestService;
import com.swiftmq.tools.requestreply.RequestServiceRegistry;
import com.swiftmq.tools.requestreply.TransportException;
import com.swiftmq.tools.timer.TimerEvent;
import com.swiftmq.tools.timer.TimerListener;
import com.swiftmq.tools.timer.TimerRegistry;
import com.swiftmq.tools.util.DataByteArrayInputStream;
import com.swiftmq.tools.util.DataByteArrayOutputStream;
import com.swiftmq.util.SwiftUtilities;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class EndpointImpl
extends RequestServiceRegistry
implements RequestHandler,
TimerListener,
MessageAvailabilityListener,
Endpoint {
    static final LeaseRequest leaseRequest = new LeaseRequest();
    static final ProtocolFactory factory = new ProtocolFactory(new com.swiftmq.mgmt.protocol.v750.ProtocolFactory());
    String routerName = null;
    String[] actContext = null;
    Connection connection = null;
    Session session = null;
    Producer producer = null;
    Consumer consumer = null;
    AddressIF replyAddress = null;
    RequestRegistry requestRegistry = null;
    DataByteArrayInputStream dis = new DataByteArrayInputStream();
    DataByteArrayOutputStream dos = new DataByteArrayOutputStream();
    byte[] buffer = null;
    CommandRegistry commandRegistry = null;
    boolean createInternalCommands = false;
    long interval = 0L;
    boolean started = false;
    boolean routeInfos = false;
    boolean subscriptionFilterEnabled = false;
    ConnectReply connectReply = null;
    Map subscriptions = new HashMap();
    ExecutorService pollerService = Executors.newSingleThreadExecutor();
    Poller poller = null;

    public EndpointImpl(Connection connection, Session session, Producer producer, Consumer consumer, AddressIF replyAddress, RequestService requestService, boolean createInternalCommands) throws Exception {
        this.connection = connection;
        this.createInternalCommands = createInternalCommands;
        this.session = session;
        this.producer = producer;
        this.replyAddress = replyAddress;
        this.consumer = consumer;
        this.addRequestService(requestService);
        this.requestRegistry = new RequestRegistry();
        this.requestRegistry.setRequestTimeoutEnabled(true);
        this.requestRegistry.setRequestHandler(this);
        this.commandRegistry = new CommandRegistry("Router Context", null);
        this.createCommands();
        this.createDefaultExecutor();
        this.poller = new Poller(this);
        this.pollerService.execute(this.poller);
    }

    private void createCommands() {
        if (this.createInternalCommands) {
            CommandExecutor getPropExecutor = new CommandExecutor(){

                @Override
                public String[] execute(String[] context, Entity entity, String[] cmd) {
                    String[] result = null;
                    try {
                        CommandReply reply = (CommandReply)EndpointImpl.this.requestRegistry.request(new CommandRequest(context, cmd, true));
                        result = reply.isOk() ? reply.getResult() : new String[]{"Error:", reply.getException().getMessage()};
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return result;
                }
            };
            Command getPropCommand = new Command("getcontextprop", "getcontextprop", "Internal use only!", true, getPropExecutor);
            this.commandRegistry.addCommand(getPropCommand);
            CommandExecutor getSubsExecutor = new CommandExecutor(){

                @Override
                public String[] execute(String[] context, Entity entity, String[] cmd) {
                    String[] result = null;
                    try {
                        CommandReply reply = (CommandReply)EndpointImpl.this.requestRegistry.request(new CommandRequest(context, cmd, true));
                        result = reply.isOk() ? reply.getResult() : new String[]{"Error:", reply.getException().getMessage()};
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return result;
                }
            };
            Command getSubsCommand = new Command("getcontextent", "getcontextent", "Internal use only!", true, getPropExecutor);
            this.commandRegistry.addCommand(getSubsCommand);
        }
        CommandExecutor ccExecutor = new CommandExecutor(){

            @Override
            public String[] execute(String[] context, Entity entity, String[] cmd) {
                if (cmd.length != 2) {
                    return new String[]{"Error:", "Invalid command, please try 'cc <context>'"};
                }
                if (cmd[1].equals("..")) {
                    EndpointImpl.this.actContext = SwiftUtilities.cutLast(EndpointImpl.this.actContext);
                    return null;
                }
                String[] result = null;
                try {
                    CommandReply reply = (CommandReply)EndpointImpl.this.requestRegistry.request(new CommandRequest(cmd[1].startsWith("/") ? null : EndpointImpl.this.actContext, cmd, true));
                    if (reply.isOk()) {
                        result = reply.getResult();
                        if (result == null) {
                            EndpointImpl.this.actContext = cmd[1].startsWith("/") ? SwiftUtilities.tokenize(cmd[1], "/") : SwiftUtilities.append(EndpointImpl.this.actContext, SwiftUtilities.tokenize(cmd[1], "/"));
                        }
                    } else {
                        result = new String[]{"Error:", reply.getException().getMessage()};
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return result;
            }
        };
        Command ccCommand = new Command("cc", "cc <context>", "Change to Context <context>", true, ccExecutor);
        this.commandRegistry.addCommand(ccCommand);
        CommandExecutor lcExecutor = new CommandExecutor(){

            @Override
            public String[] execute(String[] context, Entity entity, String[] cmd) {
                String[] result = null;
                try {
                    CommandReply reply;
                    String[] ctx = EndpointImpl.this.actContext;
                    if (cmd.length == 2) {
                        ctx = cmd[1].startsWith("/") ? SwiftUtilities.tokenize(cmd[1], "/") : SwiftUtilities.append(EndpointImpl.this.actContext, SwiftUtilities.tokenize(cmd[1], "/"));
                    }
                    result = (reply = (CommandReply)EndpointImpl.this.requestRegistry.request(new CommandRequest(ctx, cmd, true))).isOk() ? reply.getResult() : new String[]{"Error:", reply.getException().getMessage()};
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return result;
            }
        };
        Command lcCommand = new Command("lc", "lc [<context>]", "List the Content of <context>", true, lcExecutor);
        this.commandRegistry.addCommand(lcCommand);
        CommandExecutor authExecutor = new CommandExecutor(){

            @Override
            public String[] execute(String[] context, Entity entity, String[] cmd) {
                if (cmd.length != 2) {
                    return new String[]{"Error:", "Invalid command, please try 'authenticate <password>'"};
                }
                try {
                    EndpointImpl.this.authenticate(cmd[1]);
                }
                catch (Exception e) {
                    return new String[]{"Error:", e.getMessage()};
                }
                return null;
            }
        };
        Command authCommand = new Command("authenticate", "authenticate <password>", "Authenticate Access", true, authExecutor);
        this.commandRegistry.addCommand(authCommand);
    }

    private void createDefaultExecutor() {
        CommandExecutor defaultExecutor = new CommandExecutor(){

            @Override
            public String[] execute(String[] context, Entity entity, String[] command) {
                String[] result = null;
                try {
                    CommandReply reply = (CommandReply)EndpointImpl.this.requestRegistry.request(new CommandRequest(EndpointImpl.this.actContext, command, false));
                    result = reply.isOk() ? reply.getResult() : new String[]{"Error:", reply.getException().getMessage()};
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return result;
            }
        };
        this.commandRegistry.setDefaultCommand(defaultExecutor);
    }

    @Override
    public void connect(int connectId, String hostname, String toolName, boolean subscribeRouteInfos, boolean subscribeRouterConfig, boolean subscribeChangeEvents) throws Exception {
        ConnectRequest cr = new ConnectRequest(connectId, InetAddress.getLocalHost().getHostName(), toolName, subscribeRouteInfos, subscribeRouterConfig, subscribeChangeEvents);
        ConnectReply reply = (ConnectReply)this.request(cr);
        if (!reply.isOk()) {
            throw reply.getException();
        }
        this.setRouterName(reply.getRouterName());
        this.startLease(reply.getLeaseTimeout() / 2L);
        this.setStarted(true);
        this.connectReply = reply;
    }

    @Override
    public boolean isAuthenticationRequired() {
        return this.connectReply.isAuthRequired();
    }

    @Override
    public void authenticate(String password) throws Exception {
        ChallengeResponseFactory crFactory = (ChallengeResponseFactory)Class.forName(this.connectReply.getCrFactory()).newInstance();
        AuthReply reply = (AuthReply)this.request(new AuthRequest(crFactory.createResponse(this.connectReply.getChallenge(), password)));
        if (!reply.isOk()) {
            throw reply.getException();
        }
    }

    @Override
    public boolean isStarted() {
        return this.started;
    }

    @Override
    public void setStarted(boolean started) {
        this.started = started;
    }

    @Override
    public boolean isRouteInfos() {
        return this.routeInfos;
    }

    @Override
    public void setRouteInfos(boolean routeInfos) {
        this.routeInfos = routeInfos;
    }

    @Override
    public RequestRegistry getRequestRegistry() {
        return this.requestRegistry;
    }

    @Override
    public String getRouterName() {
        return this.routerName;
    }

    @Override
    public void setRouterName(String routerName) {
        this.routerName = routerName;
    }

    @Override
    public String[] getActContext() {
        return this.actContext;
    }

    @Override
    public void setActContext(String[] actContext) {
        this.actContext = actContext;
    }

    @Override
    public boolean isSubscriptionFilterEnabled() {
        return this.subscriptionFilterEnabled;
    }

    @Override
    public void setSubscriptionFilterEnabled(boolean subscriptionFilterEnabled) {
        this.subscriptionFilterEnabled = subscriptionFilterEnabled;
    }

    @Override
    public void contextShown(String[] context, boolean includeNextLevel) {
        if (this.subscriptionFilterEnabled) {
            String s = SwiftUtilities.concat(context, "/") + "?" + includeNextLevel;
            SubscriptionCounter c = (SubscriptionCounter)this.subscriptions.get(s);
            if (c == null) {
                c = new SubscriptionCounter();
                this.subscriptions.put(s, c);
                this.requestRegistry.request(new SetSubscriptionFilterRequest(context, includeNextLevel));
            }
            ++c.cnt;
        }
    }

    @Override
    public void contextHidden(String[] context, boolean includeNextLevel) {
        String s;
        SubscriptionCounter c;
        if (this.subscriptionFilterEnabled && (c = (SubscriptionCounter)this.subscriptions.get(s = SwiftUtilities.concat(context, "/") + "?" + includeNextLevel)) != null) {
            --c.cnt;
            if (c.cnt == 0) {
                this.subscriptions.remove(s);
                this.requestRegistry.request(new RemoveSubscriptionFilterRequest(context, includeNextLevel));
            }
        }
    }

    @Override
    public void startLease(long interval) {
        this.interval = interval;
        TimerRegistry.Singleton().addTimerListener(interval, (TimerListener)this);
    }

    @Override
    public Reply request(Request request) throws Exception {
        return this.requestRegistry.request(request);
    }

    @Override
    public synchronized void performRequest(Request request) {
        try {
            this.dos.rewind();
            Dumpalizer.dump(this.dos, request);
            AMQPMessage msg = new AMQPMessage();
            byte[] bytes = new byte[this.dos.getCount()];
            System.arraycopy(this.dos.getBuffer(), 0, bytes, 0, bytes.length);
            msg.addData(new Data(bytes));
            Properties prop = new Properties();
            if (this.connection.getUserName() == null) {
                prop.setUserId(new AMQPBinary("anonymous".getBytes()));
            } else {
                prop.setUserId(new AMQPBinary(this.connection.getUserName().getBytes()));
            }
            prop.setReplyTo(this.replyAddress);
            msg.setProperties(prop);
            this.producer.send(msg);
        }
        catch (Exception e) {
            this.close();
        }
    }

    @Override
    public String[] execute(String[] context, Entity entity, String[] command) {
        return this.commandRegistry.executeCommand(context, command);
    }

    @Override
    public void performTimeAction(TimerEvent evt) {
        this.performRequest(leaseRequest);
    }

    @Override
    public void messageAvailable(Consumer consumer) {
        this.pollerService.execute(this.poller);
    }

    public void poll() {
        try {
            AMQPMessage msg = this.consumer.receiveNoWait(this);
            if (msg != null) {
                Data data = msg.getData().get(0);
                this.dis.reset();
                this.dis.setBuffer(data.getValue());
                Dumpable d = Dumpalizer.construct(this.dis, factory);
                if (d instanceof Reply) {
                    this.requestRegistry.setReply((Reply)d);
                } else {
                    this.dispatch((Request)d);
                }
                this.pollerService.execute(this.poller);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.close();
        }
    }

    @Override
    public void close() {
        this.pollerService.shutdown();
        this.requestRegistry.cancelAllRequests(new TransportException("Request cancelled."));
        this.requestRegistry.close();
        TimerRegistry.Singleton().removeTimerListener(this.interval, (TimerListener)this);
        try {
            this.consumer.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.producer.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.session.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private class SubscriptionCounter {
        int cnt = 0;

        private SubscriptionCounter() {
        }
    }

    private static class Poller
    implements Runnable {
        EndpointImpl endpoint = null;

        private Poller(EndpointImpl endpoint) {
            this.endpoint = endpoint;
        }

        @Override
        public void run() {
            this.endpoint.poll();
        }
    }
}

