/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.amqp.v100.transport;

import com.swiftmq.amqp.Writable;
import com.swiftmq.amqp.v100.generated.security.sasl.SaslFrameIF;
import com.swiftmq.amqp.v100.generated.security.sasl.SaslFrameVisitor;
import com.swiftmq.amqp.v100.generated.transport.performatives.FrameIF;
import com.swiftmq.amqp.v100.generated.transport.performatives.FrameVisitor;
import com.swiftmq.amqp.v100.types.Util;
import com.swiftmq.tools.concurrent.AsyncCompletionCallback;
import com.swiftmq.tools.concurrent.Semaphore;
import com.swiftmq.tools.util.DataByteArrayOutputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public abstract class AMQPFrame
implements Writable,
FrameIF,
SaslFrameIF {
    public static byte TYPE_CODE_AMQP_FRAME = 0;
    public static byte TYPE_CODE_SASL_FRAME = 1;
    protected static int HEADER_SIZE = 8;
    long frameSize = HEADER_SIZE;
    byte dataOffset = (byte)2;
    byte typeCode = TYPE_CODE_AMQP_FRAME;
    int channel = 0;
    byte[] header = new byte[HEADER_SIZE];
    byte[] payload = null;
    List morePayloads = null;
    DataByteArrayOutputStream dos = null;
    volatile Semaphore semaphore = null;
    volatile AsyncCompletionCallback callback = null;

    protected AMQPFrame(int channel) {
        this.channel = channel;
    }

    public int getChannel() {
        return this.channel;
    }

    public void setChannel(int channel) {
        this.channel = channel;
    }

    protected void setTypeCode(byte typeCode) {
        this.typeCode = typeCode;
    }

    @Override
    public Semaphore getSemaphore() {
        return this.semaphore;
    }

    public void setSemaphore(Semaphore semaphore) {
        this.semaphore = semaphore;
    }

    @Override
    public AsyncCompletionCallback getCallback() {
        return this.callback;
    }

    public void setCallback(AsyncCompletionCallback callback) {
        this.callback = callback;
    }

    @Override
    public int getPredictedSize() {
        int size = HEADER_SIZE;
        if (this.payload != null) {
            size += this.payload.length;
        }
        return size;
    }

    public byte[] getPayload() {
        return this.payload;
    }

    public void setPayload(byte[] payload) {
        this.payload = payload;
    }

    public void addMorePayload(byte[] payload) {
        if (this.morePayloads == null) {
            this.morePayloads = new ArrayList();
        }
        this.morePayloads.add(payload);
    }

    public List getMorePayloads() {
        return this.morePayloads;
    }

    public int getPayloadLength() {
        int n = this.payload.length;
        if (this.morePayloads != null) {
            for (int i = 0; i < this.morePayloads.size(); ++i) {
                n += ((byte[])this.morePayloads.get(i)).length;
            }
        }
        return n;
    }

    @Override
    public void accept(FrameVisitor visitor) {
    }

    @Override
    public void accept(SaslFrameVisitor visitor) {
    }

    protected abstract void writeBody(DataOutput var1) throws IOException;

    @Override
    public void writeContent(DataOutput out) throws IOException {
        if (this.dos == null) {
            this.dos = new DataByteArrayOutputStream();
        }
        this.dos.rewind();
        this.writeBody(this.dos);
        this.frameSize = HEADER_SIZE + this.dos.getCount() + (this.payload != null ? this.payload.length : 0);
        Util.writeInt((int)this.frameSize, this.header, 0);
        this.header[4] = this.dataOffset;
        this.header[5] = this.typeCode;
        Util.writeShort(this.channel, this.header, 6);
        out.write(this.header);
        if (this.dos.getCount() > 0) {
            out.write(this.dos.getBuffer(), 0, this.dos.getCount());
        }
        if (this.payload != null) {
            out.write(this.payload, 0, this.payload.length);
        }
    }

    @Override
    public String getValueString() {
        return null;
    }

    public String toString() {
        return "[AMQPFrame, frameSize=" + this.frameSize + ", dataOffset=" + this.dataOffset + ", typeCode=" + this.typeCode + ", channel=" + this.channel + ", payload=" + (this.payload != null ? this.payload.length + " bytes" : "null") + "]";
    }
}

