/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.amqp.v100.transport;

import com.swiftmq.amqp.v100.generated.transport.definitions.MessageFormat;
import com.swiftmq.amqp.v100.generated.transport.performatives.TransferFrame;
import com.swiftmq.amqp.v100.types.AMQPBoolean;
import com.swiftmq.tools.util.DataByteArrayInputStream;
import java.io.IOException;

public class Packager {
    int channel = 0;
    int handle = 0;
    boolean settled = false;
    byte[] data = null;
    int size = 0;
    DataByteArrayInputStream dbis = null;
    int maxPacketLength = 0;
    int currentPacketNumber = 0;
    long messageFormat = -1L;
    int predictedNumberPackets = -1;

    public void setChannel(int channel) {
        this.channel = channel;
    }

    public void setHandle(int handle) {
        this.handle = handle;
    }

    public void setSettled(boolean settled) {
        this.settled = settled;
    }

    public void setData(byte[] data, int size) {
        this.data = data;
        this.size = size;
    }

    public byte[] getData() {
        return this.data;
    }

    public void setData(byte[] data) {
        this.setData(data, data.length);
    }

    public int getSize() {
        return this.size;
    }

    public long getMessageFormat() {
        return this.messageFormat;
    }

    public void setMessageFormat(long messageFormat) {
        this.messageFormat = messageFormat;
    }

    public void setMaxFrameSize(int maxFrameSize) {
        this.maxPacketLength = maxFrameSize;
    }

    public int getMaxPayloadLength() {
        return this.maxPacketLength;
    }

    public int getPredictedNumberPackets() {
        return this.predictedNumberPackets;
    }

    public void getNextPacket(TransferFrame currentFrame) throws IOException {
        currentFrame.setMore(AMQPBoolean.FALSE);
        if (this.messageFormat != -1L) {
            currentFrame.setMessageFormat(new MessageFormat(this.messageFormat));
        }
        ++this.currentPacketNumber;
        byte[] b = null;
        if (this.dbis != null) {
            int len = Math.min(this.dbis.available(), this.maxPacketLength - currentFrame.getPredictedSize());
            b = new byte[len];
            this.dbis.readFully(b);
        } else if (this.maxPacketLength - currentFrame.getPredictedSize() - this.size >= 0) {
            if (this.data.length != this.size) {
                b = new byte[this.size];
                System.arraycopy(this.data, 0, b, 0, this.size);
                this.data = null;
            } else {
                b = this.data;
            }
        } else {
            if (this.dbis == null) {
                this.dbis = new DataByteArrayInputStream();
                this.dbis.setBuffer(this.data, 0, this.size);
            }
            int len = Math.min(this.dbis.available(), this.maxPacketLength - currentFrame.getPredictedSize());
            b = new byte[len];
            this.dbis.readFully(b);
        }
        if (this.hasMore()) {
            currentFrame.setMore(AMQPBoolean.TRUE);
        }
        currentFrame.setPayload(b);
        if (this.predictedNumberPackets == -1) {
            this.predictedNumberPackets = this.size / b.length + 1;
        }
    }

    public int getCurrentPacketNumber() {
        return this.currentPacketNumber;
    }

    public boolean hasMore() throws IOException {
        return this.dbis != null && this.dbis.available() > 0;
    }
}

