/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.amqp.v100.types;

import com.swiftmq.amqp.v100.types.AMQPDescribedConstructor;
import com.swiftmq.amqp.v100.types.AMQPType;
import com.swiftmq.amqp.v100.types.AMQPTypeDecoder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;

public class AMQPArray
extends AMQPType {
    int typeCode = -1;
    AMQPDescribedConstructor eleConstructor = null;
    AMQPType[] array = null;
    byte[] bytes = null;
    byte[] valueBytes = null;

    public AMQPArray() {
        super("array", 255);
    }

    public AMQPArray(AMQPDescribedConstructor eleConstructor, AMQPType[] array) throws IOException {
        super("array", 255);
        this.setValue(eleConstructor, array);
    }

    public AMQPArray(int typeCode, AMQPType[] array) throws IOException {
        super("array", 255);
        this.setValue(typeCode, array);
    }

    private void writeNoCode(DataOutputStream dos, AMQPType t) throws IOException {
        boolean oldValue = t.isWriteCode();
        t.setWriteCode(false);
        t.writeContent(dos);
        t.setWriteCode(oldValue);
    }

    public void setValue(AMQPDescribedConstructor eleConstructor, AMQPType[] array) throws IOException {
        this.eleConstructor = eleConstructor;
        this.array = array;
        if (array != null) {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(bos);
            eleConstructor.writeContent(dos);
            for (int i = 0; i < array.length; ++i) {
                this.writeNoCode(dos, array[i]);
            }
            dos.close();
            this.valueBytes = bos.toByteArray();
            this.bytes = null;
            this.code = this.valueBytes.length > 255 || array.length > 255 ? 240 : 224;
        }
    }

    public void setValue(int typeCode, AMQPType[] array) throws IOException {
        this.typeCode = typeCode;
        this.array = array;
        if (array != null) {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(bos);
            dos.writeByte(typeCode);
            for (int i = 0; i < array.length; ++i) {
                this.writeNoCode(dos, array[i]);
            }
            dos.close();
            this.valueBytes = bos.toByteArray();
            this.bytes = null;
            this.code = this.valueBytes.length > 254 || array.length > 255 ? 240 : 224;
        }
    }

    public AMQPType[] getValue() throws IOException {
        if (this.array == null) {
            DataInputStream dis = new DataInputStream(new ByteArrayInputStream(this.bytes));
            int n = 0;
            if (this.code == 224) {
                n = dis.readUnsignedByte();
            } else if (this.code == 240) {
                n = dis.readInt();
            } else {
                throw new IOException("Invalid code: " + this.code);
            }
            if (n < 0) {
                throw new IOException("Invalid array element count: " + n);
            }
            this.typeCode = dis.readUnsignedByte();
            if (this.typeCode == 0) {
                this.eleConstructor = new AMQPDescribedConstructor();
                this.eleConstructor.readContent(dis);
                this.typeCode = this.eleConstructor.getFormatCode();
            }
            this.array = new AMQPType[n];
            for (int i = 0; i < n; ++i) {
                this.array[i] = AMQPTypeDecoder.decode(this.typeCode, dis);
            }
        }
        return this.array;
    }

    public AMQPDescribedConstructor getEleConstructor() throws IOException {
        this.getValue();
        return this.eleConstructor;
    }

    public int getTypeCode() throws IOException {
        this.getValue();
        return this.typeCode;
    }

    @Override
    public int getPredictedSize() {
        int n = super.getPredictedSize();
        if (this.eleConstructor != null) {
            n += this.eleConstructor.getPredictedSize();
        }
        n = this.code == 224 ? ++n : (n += 4);
        if (this.bytes != null) {
            n += this.bytes.length;
        } else if (this.array != null) {
            for (int i = 0; i < this.array.length; ++i) {
                n += this.array[i].getPredictedSize();
            }
        }
        return n;
    }

    @Override
    public void readContent(DataInput in) throws IOException {
        int len = 0;
        if (this.code == 224) {
            len = in.readUnsignedByte();
        } else if (this.code == 240) {
            len = in.readInt();
        } else {
            throw new IOException("Invalid code: " + this.code);
        }
        if (len < 0) {
            throw new IOException("byte[] array length invalid: " + len);
        }
        this.bytes = new byte[len];
        in.readFully(this.bytes);
    }

    @Override
    public void writeContent(DataOutput out) throws IOException {
        super.writeContent(out);
        if (this.bytes != null) {
            if (this.code == 224) {
                out.writeByte(this.bytes.length);
            } else if (this.code == 240) {
                out.writeInt(this.bytes.length);
            }
            out.write(this.bytes);
        } else {
            if (this.code == 224) {
                out.writeByte(this.valueBytes.length + 1);
                out.writeByte(this.array.length);
            } else if (this.code == 240) {
                out.writeInt(this.valueBytes.length + 4);
                out.writeInt(this.array.length);
            }
            out.write(this.valueBytes);
        }
    }

    private String printArray() {
        StringBuffer b = new StringBuffer("\n");
        for (int i = 0; i < this.array.length; ++i) {
            b.append(i);
            b.append(": ");
            b.append(this.array[i].toString());
            b.append("\n");
        }
        return b.toString();
    }

    @Override
    public String getValueString() {
        try {
            this.getValue();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        StringBuffer b = new StringBuffer("[");
        for (int i = 0; i < this.array.length; ++i) {
            if (i > 0) {
                b.append(", ");
            }
            b.append(this.array[i].getValueString());
        }
        b.append("]");
        return b.toString();
    }

    @Override
    public String toString() {
        try {
            this.getValue();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return "[AMQPArray, eleConstructor=" + this.eleConstructor + ", typeCode=" + this.typeCode + ", array=" + (this.array == null ? "null" : this.printArray()) + ", bytes.length=" + (this.bytes != null ? Integer.valueOf(this.bytes.length) : "null") + ", valueBytes.length=" + (this.valueBytes != null ? Integer.valueOf(this.valueBytes.length) : "null") + super.toString() + "]";
    }
}

