/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.amqp.v100.types;

import com.swiftmq.amqp.v100.types.AMQPType;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;

public class AMQPBinary
extends AMQPType {
    byte[] value;
    String valueString = null;
    int hashCode = -1;

    public AMQPBinary() {
        super("binary", 255);
    }

    public AMQPBinary(byte[] value) {
        super("binary", 255);
        this.setValue(value);
    }

    public byte[] getValue() {
        return this.value;
    }

    public void setValue(byte[] value) {
        this.value = value;
        this.code = value.length > 255 ? 176 : 160;
        this.hashCode = Arrays.hashCode(value);
    }

    @Override
    public int getPredictedSize() {
        int n = super.getPredictedSize();
        n = this.code == 160 ? ++n : (n += 4);
        if (this.value != null) {
            n += this.value.length;
        }
        return n;
    }

    @Override
    public void readContent(DataInput in) throws IOException {
        int len = 0;
        if (this.code == 160) {
            len = in.readUnsignedByte();
        } else if (this.code == 176) {
            len = in.readInt();
        } else {
            throw new IOException("Invalid code: " + this.code);
        }
        if (len < 0) {
            throw new IOException("byte[] array length invalid: " + len);
        }
        this.value = new byte[len];
        in.readFully(this.value);
        this.hashCode = Arrays.hashCode(this.value);
    }

    @Override
    public void writeContent(DataOutput out) throws IOException {
        super.writeContent(out);
        if (this.code == 160) {
            out.writeByte(this.value.length);
        } else {
            out.writeInt(this.value.length);
        }
        out.write(this.value);
    }

    @Override
    public String getValueString() {
        if (this.valueString == null) {
            if (this.value == null) {
                this.valueString = "null";
            } else {
                StringBuffer b = new StringBuffer();
                int len = Math.min(255, this.value.length);
                for (int i = 0; i < len; ++i) {
                    b.append(String.format("%02X", this.value[i]));
                }
                if (this.value.length > 255) {
                    b.append("...");
                }
                this.valueString = b.toString();
            }
        }
        return this.valueString;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object o) {
        if (!(o instanceof AMQPBinary)) {
            return false;
        }
        return Arrays.equals(((AMQPBinary)o).getValue(), this.value);
    }

    @Override
    public String toString() {
        return "[AMQPBinary, value.length=" + (this.value == null ? "null" : Integer.valueOf(this.value.length)) + " " + super.toString() + "]";
    }
}

