/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.amqp.v100.types;

import com.swiftmq.amqp.v100.types.AMQPType;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class AMQPBoolean
extends AMQPType {
    public static final AMQPBoolean TRUE = new AMQPBoolean(true);
    public static final AMQPBoolean FALSE = new AMQPBoolean(false);

    public AMQPBoolean(int code) {
        super("boolean", code);
    }

    public AMQPBoolean(boolean value) {
        super("boolean", value ? 65 : 66);
    }

    public boolean getValue() {
        return this.code == 65;
    }

    @Override
    public void readContent(DataInput in) throws IOException {
        if (this.code == 86) {
            byte b = in.readByte();
            this.setCode(b == 0 ? 66 : 65);
        }
    }

    @Override
    public void writeContent(DataOutput out) throws IOException {
        super.writeContent(out);
    }

    @Override
    public String getValueString() {
        return this.code == 65 ? "TRUE" : "FALSE";
    }

    @Override
    public String toString() {
        return "[AMQPBoolean, value=" + this.getValue() + " " + super.toString() + "]";
    }
}

