/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.amqp.v100.types;

import com.swiftmq.amqp.v100.types.AMQPType;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class AMQPByte
extends AMQPType {
    byte value;

    public AMQPByte() {
        super("byte", 81);
    }

    public AMQPByte(byte value) {
        super("byte", 81);
        this.setValue(value);
    }

    public byte getValue() {
        return this.value;
    }

    public void setValue(byte value) {
        this.value = value;
    }

    @Override
    public int getPredictedSize() {
        int n = super.getPredictedSize() + 1;
        return n;
    }

    @Override
    public void readContent(DataInput in) throws IOException {
        this.value = in.readByte();
    }

    @Override
    public void writeContent(DataOutput out) throws IOException {
        super.writeContent(out);
        out.writeByte(this.value);
    }

    @Override
    public String getValueString() {
        return Byte.toString(this.value);
    }

    @Override
    public String toString() {
        return "[AMQPByte, value=" + this.getValue() + " " + super.toString() + "]";
    }
}

