/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.amqp.v100.types;

import com.swiftmq.amqp.v100.types.AMQPType;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class AMQPChar
extends AMQPType {
    int value;

    public AMQPChar() {
        super("char", 115);
    }

    public AMQPChar(int value) {
        super("char", 115);
        this.setValue(value);
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int value) {
        this.value = value;
    }

    @Override
    public int getPredictedSize() {
        int n = super.getPredictedSize() + 4;
        return n;
    }

    @Override
    public void readContent(DataInput in) throws IOException {
        this.value = in.readInt();
    }

    @Override
    public void writeContent(DataOutput out) throws IOException {
        super.writeContent(out);
        out.writeInt(this.value);
    }

    @Override
    public String getValueString() {
        return String.valueOf(this.value);
    }

    @Override
    public String toString() {
        return "[AMQPChar, value=" + this.getValue() + " " + super.toString() + "]";
    }
}

