/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.amqp.v100.types;

import com.swiftmq.amqp.v100.types.AMQPType;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class AMQPDecimal128
extends AMQPType {
    byte[] bytes = new byte[16];

    public AMQPDecimal128() {
        super("decimal128", 148);
    }

    public AMQPDecimal128(byte[] value) {
        super("decimal128", 148);
        this.setValue(value);
    }

    public byte[] getValue() {
        return this.bytes;
    }

    public void setValue(byte[] value) {
        System.arraycopy(value, 0, this.bytes, 0, Math.min(value.length, this.bytes.length));
    }

    @Override
    public int getPredictedSize() {
        int n = super.getPredictedSize() + this.bytes.length;
        return n;
    }

    @Override
    public void readContent(DataInput in) throws IOException {
        in.readFully(this.bytes);
    }

    @Override
    public void writeContent(DataOutput out) throws IOException {
        super.writeContent(out);
        out.write(this.bytes);
    }

    @Override
    public String getValueString() {
        return this.getValue().toString();
    }

    @Override
    public String toString() {
        return "[AMQPDecimal128, value=" + this.getValue() + " " + super.toString() + "]";
    }
}

