/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.amqp.v100.types;

import com.swiftmq.amqp.v100.types.AMQPType;
import com.swiftmq.amqp.v100.types.Util;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.MathContext;

public class AMQPDecimal32
extends AMQPType {
    byte[] bytes = new byte[4];

    public AMQPDecimal32() {
        super("decimal32", 116);
    }

    public AMQPDecimal32(BigDecimal value) {
        super("decimal32", 116);
        this.setValue(value);
    }

    public BigDecimal getValue() {
        return new BigDecimal(Util.readInt(this.bytes, 0), MathContext.DECIMAL32);
    }

    public void setValue(BigDecimal value) {
        Util.writeInt(value.intValue(), this.bytes, 0);
    }

    @Override
    public int getPredictedSize() {
        int n = super.getPredictedSize() + this.bytes.length;
        return n;
    }

    @Override
    public void readContent(DataInput in) throws IOException {
        in.readFully(this.bytes);
    }

    @Override
    public void writeContent(DataOutput out) throws IOException {
        super.writeContent(out);
        out.write(this.bytes);
    }

    @Override
    public String getValueString() {
        return this.getValue().toString();
    }

    @Override
    public String toString() {
        return "[AMQPDecimal32, value=" + this.getValue() + " " + super.toString() + "]";
    }
}

