/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.amqp.v100.types;

import com.swiftmq.amqp.v100.types.AMQPType;
import com.swiftmq.amqp.v100.types.Util;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.MathContext;

public class AMQPDecimal64
extends AMQPType {
    byte[] bytes = new byte[8];

    public AMQPDecimal64() {
        super("decimal64", 132);
    }

    public AMQPDecimal64(BigDecimal value) {
        super("decimal64", 132);
        this.setValue(value);
    }

    public BigDecimal getValue() {
        return new BigDecimal(Util.readLong(this.bytes, 0), MathContext.DECIMAL64);
    }

    public void setValue(BigDecimal value) {
        Util.writeLong(value.longValue(), this.bytes, 0);
    }

    @Override
    public int getPredictedSize() {
        int n = super.getPredictedSize() + this.bytes.length;
        return n;
    }

    @Override
    public void readContent(DataInput in) throws IOException {
        in.readFully(this.bytes);
    }

    @Override
    public void writeContent(DataOutput out) throws IOException {
        super.writeContent(out);
        out.write(this.bytes);
    }

    @Override
    public String getValueString() {
        return this.getValue().toString();
    }

    @Override
    public String toString() {
        return "[AMQPDecimal64, value=" + this.getValue() + " " + super.toString() + "]";
    }
}

