/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.amqp.v100.types;

import com.swiftmq.amqp.v100.types.AMQPType;
import com.swiftmq.amqp.v100.types.AMQPTypeDecoder;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class AMQPDescribedConstructor
extends AMQPType {
    AMQPType descriptor = null;
    int formatCode = 0;

    public AMQPDescribedConstructor(AMQPType descriptor, int formatCode) {
        this();
        this.descriptor = descriptor;
        this.formatCode = formatCode;
    }

    public AMQPDescribedConstructor() {
        super("describedconstructor", 0);
    }

    public AMQPType getDescriptor() {
        return this.descriptor;
    }

    public int getFormatCode() {
        return this.formatCode;
    }

    public void setFormatCode(int formatCode) {
        this.formatCode = formatCode;
    }

    @Override
    public int getPredictedSize() {
        int n = super.getPredictedSize() + 1;
        if (this.descriptor != null) {
            n += this.descriptor.getPredictedSize();
        }
        return n;
    }

    @Override
    public void readContent(DataInput in) throws IOException {
        this.descriptor = AMQPTypeDecoder.decode(in);
        this.formatCode = in.readUnsignedByte();
    }

    @Override
    public void writeContent(DataOutput out) throws IOException {
        super.writeContent(out);
        this.descriptor.writeContent(out);
        if (this.formatCode != 255) {
            out.writeByte(this.formatCode);
        }
    }

    @Override
    public String getValueString() {
        return this.descriptor.getValueString() + "/0x" + Integer.toHexString(this.formatCode);
    }

    @Override
    public String toString() {
        return "[AMQPDescribedConstructor, descriptor=" + this.descriptor + ", formatCode=0x" + Integer.toHexString(this.formatCode) + super.toString() + "]";
    }
}

