/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.amqp.v100.types;

import com.swiftmq.amqp.v100.types.AMQPType;
import com.swiftmq.amqp.v100.types.Util;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class AMQPDouble
extends AMQPType {
    byte[] bytes = new byte[8];

    public AMQPDouble() {
        super("double", 130);
    }

    public AMQPDouble(double value) {
        super("double", 130);
        this.setValue(value);
    }

    public double getValue() {
        return Util.readDouble(this.bytes, 0);
    }

    public void setValue(double value) {
        Util.writeDouble(value, this.bytes, 0);
    }

    @Override
    public int getPredictedSize() {
        int n = super.getPredictedSize() + this.bytes.length;
        return n;
    }

    @Override
    public void readContent(DataInput in) throws IOException {
        in.readFully(this.bytes);
    }

    @Override
    public void writeContent(DataOutput out) throws IOException {
        super.writeContent(out);
        out.write(this.bytes);
    }

    @Override
    public String getValueString() {
        return Double.toString(this.getValue());
    }

    @Override
    public String toString() {
        return "[AMQPDouble, value=" + this.getValue() + " " + super.toString() + "]";
    }
}

