/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.amqp.v100.types;

import com.swiftmq.amqp.v100.types.AMQPType;
import com.swiftmq.amqp.v100.types.Util;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class AMQPFloat
extends AMQPType {
    byte[] bytes = new byte[4];

    public AMQPFloat() {
        super("float", 114);
    }

    public AMQPFloat(float value) {
        super("float", 114);
        this.setValue(value);
    }

    public float getValue() {
        return Util.readFloat(this.bytes, 0);
    }

    public void setValue(float value) {
        Util.writeFloat(value, this.bytes, 0);
    }

    @Override
    public int getPredictedSize() {
        int n = super.getPredictedSize() + this.bytes.length;
        return n;
    }

    @Override
    public void readContent(DataInput in) throws IOException {
        in.readFully(this.bytes);
    }

    @Override
    public void writeContent(DataOutput out) throws IOException {
        super.writeContent(out);
        out.write(this.bytes);
    }

    @Override
    public String getValueString() {
        return Float.toString(this.getValue());
    }

    @Override
    public String toString() {
        return "[AMQPFloat, value=" + this.getValue() + " " + super.toString() + "]";
    }
}

