/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.amqp.v100.types;

import com.swiftmq.amqp.v100.types.AMQPType;
import com.swiftmq.amqp.v100.types.Util;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class AMQPInt
extends AMQPType {
    byte[] bytes = new byte[4];

    public AMQPInt() {
        super("int", 113);
    }

    public AMQPInt(int value) {
        super("int", 113);
        this.setValue(value);
    }

    public int getValue() {
        if (this.code == 113) {
            return Util.readInt(this.bytes, 0);
        }
        return this.bytes[0];
    }

    public void setValue(int value) {
        Util.writeInt(value, this.bytes, 0);
        this.code = 113;
    }

    @Override
    public int getPredictedSize() {
        int n = super.getPredictedSize();
        if (this.code == 113) {
            n += 4;
        } else if (this.code == 84) {
            ++n;
        }
        return n;
    }

    @Override
    public void readContent(DataInput in) throws IOException {
        if (this.code == 113) {
            in.readFully(this.bytes);
        } else if (this.code == 84) {
            this.bytes[0] = in.readByte();
        } else {
            throw new IOException("Invalid code: " + this.code);
        }
    }

    @Override
    public void writeContent(DataOutput out) throws IOException {
        super.writeContent(out);
        if (this.code == 113) {
            out.write(this.bytes);
        } else {
            out.writeByte(this.bytes[0]);
        }
    }

    @Override
    public String getValueString() {
        return Integer.toString(this.getValue());
    }

    @Override
    public String toString() {
        return "[AMQPInt, value=" + this.getValue() + " " + super.toString() + "]";
    }
}

