/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.amqp.v100.types;

import com.swiftmq.amqp.v100.types.AMQPType;
import com.swiftmq.amqp.v100.types.AMQPTypeDecoder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class AMQPList
extends AMQPType {
    List<AMQPType> list = null;
    byte[] bytes;
    byte[] valueBytes = null;

    public AMQPList() {
        super("list", 255);
    }

    public AMQPList(List<AMQPType> list) throws IOException {
        super("list", 255);
        this.setValue(list);
    }

    public List<AMQPType> getValue() throws IOException {
        if (this.list == null) {
            this.list = new ArrayList<AMQPType>();
            if (this.code != 69) {
                DataInputStream dis = new DataInputStream(new ByteArrayInputStream(this.bytes));
                int n = 0;
                if (this.code == 192) {
                    n = dis.readByte() & 0xFF;
                } else if (this.code == 208) {
                    n = dis.readInt();
                } else {
                    throw new IOException("Invalid code: " + this.code);
                }
                if (n < 0) {
                    throw new IOException("Invalid list element count: " + n);
                }
                for (int i = 0; i < n; ++i) {
                    this.list.add(AMQPTypeDecoder.decode(dis));
                }
            }
        }
        return this.list;
    }

    public void setValue(List<AMQPType> list) throws IOException {
        this.list = list;
        if (list != null) {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(bos);
            for (int i = 0; i < list.size(); ++i) {
                list.get(i).writeContent(dos);
            }
            dos.close();
            this.valueBytes = bos.toByteArray();
            this.bytes = null;
            this.code = list.size() == 0 ? 69 : (this.valueBytes.length > 254 || list.size() > 255 ? 208 : 192);
        }
    }

    @Override
    public int getPredictedSize() {
        int n = super.getPredictedSize();
        if (this.code == 69) {
            return n;
        }
        if (this.bytes != null) {
            n += this.bytes.length;
        } else {
            n = this.code == 192 ? ++n : (n += 4);
            if (this.valueBytes != null) {
                n += this.valueBytes.length;
            }
        }
        return n;
    }

    @Override
    public void readContent(DataInput in) throws IOException {
        if (this.code == 69) {
            return;
        }
        int len = 0;
        if (this.code == 192) {
            len = in.readByte() & 0xFF;
        } else if (this.code == 208) {
            len = in.readInt();
        } else {
            throw new IOException("Invalid code: " + this.code);
        }
        if (len < 0) {
            throw new IOException("byte[] array length invalid: " + len);
        }
        this.bytes = new byte[len];
        in.readFully(this.bytes);
    }

    @Override
    public void writeContent(DataOutput out) throws IOException {
        super.writeContent(out);
        if (this.code == 69) {
            return;
        }
        if (this.bytes != null) {
            if (this.code == 192) {
                out.writeByte(this.bytes.length);
            } else if (this.code == 208) {
                out.writeInt(this.bytes.length);
            }
            out.write(this.bytes);
        } else {
            if (this.code == 192) {
                out.writeByte(this.valueBytes.length + 1);
                out.writeByte(this.list.size());
            } else if (this.code == 208) {
                out.writeInt(this.valueBytes.length + 4);
                out.writeInt(this.list.size());
            }
            out.write(this.valueBytes);
        }
    }

    private String printList() {
        if (this.list == null) {
            return null;
        }
        StringBuffer b = new StringBuffer("\n");
        for (int i = 0; i < this.list.size(); ++i) {
            b.append(i);
            b.append(": ");
            b.append(this.list.get(i));
            b.append("\n");
        }
        return b.toString();
    }

    @Override
    public String getValueString() {
        try {
            this.getValue();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        StringBuffer b = new StringBuffer("[");
        for (int i = 0; i < this.list.size(); ++i) {
            if (i > 0) {
                b.append(", ");
            }
            b.append(this.list.get(i).getValueString());
        }
        b.append("]");
        return b.toString();
    }

    @Override
    public String toString() {
        return "[AMQPList, list=" + this.printList() + ", bytes.length=" + (this.bytes != null ? Integer.valueOf(this.bytes.length) : "null") + ", valueBytes.length=" + (this.valueBytes != null ? Integer.valueOf(this.valueBytes.length) : "null") + super.toString() + "]";
    }
}

