/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.amqp.v100.types;

import com.swiftmq.amqp.v100.types.AMQPType;
import com.swiftmq.amqp.v100.types.Util;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class AMQPLong
extends AMQPType {
    byte[] bytes = new byte[8];

    public AMQPLong() {
        super("long", 129);
    }

    public AMQPLong(long value) {
        super("long", 129);
        this.setValue(value);
    }

    public long getValue() {
        if (this.code == 129) {
            return Util.readLong(this.bytes, 0);
        }
        return this.bytes[0];
    }

    public void setValue(long value) {
        Util.writeLong(value, this.bytes, 0);
        this.code = 129;
    }

    @Override
    public int getPredictedSize() {
        int n = super.getPredictedSize();
        if (this.code == 129) {
            n += 8;
        } else if (this.code == 85) {
            ++n;
        }
        return n;
    }

    @Override
    public void readContent(DataInput in) throws IOException {
        if (this.code == 129) {
            in.readFully(this.bytes);
        } else if (this.code == 85) {
            this.bytes[0] = in.readByte();
        } else {
            throw new IOException("Invalid code: " + this.code);
        }
    }

    @Override
    public void writeContent(DataOutput out) throws IOException {
        super.writeContent(out);
        if (this.code == 129) {
            out.write(this.bytes);
        } else {
            out.writeByte(this.bytes[0]);
        }
    }

    @Override
    public String getValueString() {
        return Long.toString(this.getValue());
    }

    @Override
    public String toString() {
        return "[AMQPLong, value=" + this.getValue() + " " + super.toString() + "]";
    }
}

