/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.amqp.v100.types;

import com.swiftmq.amqp.v100.types.AMQPType;
import com.swiftmq.amqp.v100.types.AMQPTypeDecoder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class AMQPMap
extends AMQPType {
    Map<AMQPType, AMQPType> map = null;
    byte[] bytes;
    byte[] valueBytes = null;

    public AMQPMap() {
        super("map", 255);
    }

    public AMQPMap(Map<AMQPType, AMQPType> map) throws IOException {
        super("map", 255);
        this.setValue(map);
    }

    public Map<AMQPType, AMQPType> getValue() throws IOException {
        if (this.map == null) {
            this.map = new HashMap<AMQPType, AMQPType>();
            DataInputStream dis = new DataInputStream(new ByteArrayInputStream(this.bytes));
            int n = 0;
            if (this.code == 193) {
                n = dis.readByte() & 0xFF;
            } else if (this.code == 209) {
                n = dis.readInt();
            } else {
                throw new IOException("Invalid code: " + this.code);
            }
            if (n < 0) {
                throw new IOException("Invalid map element count: " + n);
            }
            for (int i = 0; i < n; i += 2) {
                this.map.put(AMQPTypeDecoder.decode(dis), AMQPTypeDecoder.decode(dis));
            }
        }
        return this.map;
    }

    public void setValue(Map<AMQPType, AMQPType> map) throws IOException {
        this.map = map;
        if (map != null) {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(bos);
            for (Map.Entry<AMQPType, AMQPType> entry : map.entrySet()) {
                entry.getKey().writeContent(dos);
                entry.getValue().writeContent(dos);
            }
            dos.close();
            this.valueBytes = bos.toByteArray();
            this.bytes = null;
            this.code = this.valueBytes.length > 254 || map.size() * 2 > 255 ? 209 : 193;
        }
    }

    @Override
    public int getPredictedSize() {
        int n = super.getPredictedSize();
        if (this.bytes != null) {
            n += this.bytes.length;
        } else {
            n = this.code == 193 ? ++n : (n += 4);
            if (this.valueBytes != null) {
                n += this.valueBytes.length;
            }
        }
        return n;
    }

    @Override
    public void readContent(DataInput in) throws IOException {
        int len = 0;
        if (this.code == 193) {
            len = in.readByte() & 0xFF;
        } else if (this.code == 209) {
            len = in.readInt();
        } else {
            throw new IOException("Invalid code: " + this.code);
        }
        if (len < 0) {
            throw new IOException("byte[] array length invalid: " + len);
        }
        this.bytes = new byte[len];
        in.readFully(this.bytes);
    }

    @Override
    public void writeContent(DataOutput out) throws IOException {
        super.writeContent(out);
        if (this.bytes != null) {
            if (this.code == 193) {
                out.writeByte(this.bytes.length);
            } else if (this.code == 209) {
                out.writeInt(this.bytes.length);
            }
            out.write(this.bytes);
        } else {
            if (this.code == 193) {
                out.writeByte(this.valueBytes.length + 1);
                out.writeByte(this.map.size() * 2);
            } else if (this.code == 209) {
                out.writeInt(this.valueBytes.length + 4);
                out.writeInt(this.map.size() * 2);
            }
            out.write(this.valueBytes);
        }
    }

    @Override
    public String getValueString() {
        Map<AMQPType, AMQPType> m = null;
        try {
            m = this.getValue();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        boolean _first = true;
        StringBuffer b = new StringBuffer("[");
        Iterator<Map.Entry<AMQPType, AMQPType>> iter = m.entrySet().iterator();
        while (iter.hasNext()) {
            if (!_first) {
                b.append(", ");
            } else {
                _first = false;
            }
            Map.Entry<AMQPType, AMQPType> entry = iter.next();
            b.append(entry.getKey().getValueString());
            b.append("=");
            b.append(entry.getValue().getValueString());
        }
        b.append("]");
        return b.toString();
    }

    @Override
    public String toString() {
        return "[AMQPMap, map=" + this.map + ", bytes.length=" + (this.bytes != null ? Integer.valueOf(this.bytes.length) : "null") + ", valueBytes.length=" + (this.valueBytes != null ? Integer.valueOf(this.valueBytes.length) : "null") + super.toString() + "]";
    }
}

