/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.amqp.v100.types;

import com.swiftmq.amqp.v100.types.AMQPType;
import com.swiftmq.amqp.v100.types.Util;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class AMQPShort
extends AMQPType {
    byte[] bytes = new byte[2];

    public AMQPShort() {
        super("short", 97);
    }

    public AMQPShort(int value) {
        super("short", 97);
        this.setValue(value);
    }

    public int getValue() {
        return Util.readShort(this.bytes, 0);
    }

    public void setValue(int value) {
        Util.writeShort(value, this.bytes, 0);
    }

    @Override
    public int getPredictedSize() {
        int n = super.getPredictedSize() + this.bytes.length;
        return n;
    }

    @Override
    public void readContent(DataInput in) throws IOException {
        in.readFully(this.bytes);
    }

    @Override
    public void writeContent(DataOutput out) throws IOException {
        super.writeContent(out);
        out.write(this.bytes);
    }

    @Override
    public String getValueString() {
        return Short.toString((short)this.getValue());
    }

    @Override
    public String toString() {
        return "[AMQPShort, value=" + this.getValue() + " " + super.toString() + "]";
    }
}

