/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.amqp.v100.types;

import com.swiftmq.amqp.v100.types.AMQPType;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;

public class AMQPSymbol
extends AMQPType
implements Comparable {
    String value = null;
    byte[] bytes;

    public AMQPSymbol() {
        super("symbol", 179);
    }

    public AMQPSymbol(String value) {
        super("symbol", 179);
        this.setValue(value);
    }

    public String getValue() {
        if (this.value == null) {
            Charset charset = Charset.forName("US-ASCII");
            this.value = charset.decode(ByteBuffer.wrap(this.bytes)).toString();
        }
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
        if (value != null) {
            Charset charset = Charset.forName("US-ASCII");
            ByteBuffer buffer = charset.encode(value);
            this.bytes = new byte[buffer.limit()];
            buffer.get(this.bytes);
            this.code = this.bytes.length > 255 ? 179 : 163;
        }
    }

    @Override
    public int getPredictedSize() {
        int n = super.getPredictedSize();
        n = this.code == 163 ? ++n : (n += 4);
        if (this.bytes != null) {
            n += this.bytes.length;
        }
        return n;
    }

    @Override
    public void readContent(DataInput in) throws IOException {
        int len = 0;
        if (this.code == 163) {
            len = in.readUnsignedByte();
        } else if (this.code == 179) {
            len = in.readInt();
        } else {
            throw new IOException("Invalid code: " + this.code);
        }
        if (len < 0) {
            throw new IOException("byte[] array length invalid: " + len);
        }
        this.bytes = new byte[len];
        try {
            in.readFully(this.bytes);
        }
        catch (Exception e) {
            System.out.println("code=" + this.code + ", len=" + len);
            e.printStackTrace();
        }
    }

    @Override
    public void writeContent(DataOutput out) throws IOException {
        super.writeContent(out);
        if (this.code == 163) {
            out.writeByte(this.bytes.length);
        } else if (this.code == 179) {
            out.writeInt(this.bytes.length);
        }
        out.write(this.bytes);
    }

    public boolean equals(Object o) {
        return this.getValue().equals(((AMQPSymbol)o).getValue());
    }

    public int compareTo(Object o) {
        return this.getValue().compareTo(((AMQPSymbol)o).getValue());
    }

    public int hashCode() {
        return this.getValue().hashCode();
    }

    @Override
    public String getValueString() {
        return this.getValue();
    }

    @Override
    public String toString() {
        return "[AMQPSymbol, value=" + this.getValue() + ", bytes.length=" + (this.bytes != null ? Integer.valueOf(this.bytes.length) : "null") + " " + super.toString() + "]";
    }
}

