/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.amqp.v100.types;

import com.swiftmq.amqp.v100.types.AMQPType;
import com.swiftmq.amqp.v100.types.Util;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class AMQPTimestamp
extends AMQPType {
    byte[] bytes = new byte[8];

    public AMQPTimestamp() {
        super("timestamp", 131);
    }

    public AMQPTimestamp(long value) {
        super("timestamp", 131);
        this.setValue(value);
    }

    public long getValue() {
        return Util.readLong(this.bytes, 0);
    }

    public void setValue(long value) {
        Util.writeLong(value, this.bytes, 0);
    }

    @Override
    public int getPredictedSize() {
        int n = super.getPredictedSize() + this.bytes.length;
        return n;
    }

    @Override
    public void readContent(DataInput in) throws IOException {
        in.readFully(this.bytes);
    }

    @Override
    public void writeContent(DataOutput out) throws IOException {
        super.writeContent(out);
        out.write(this.bytes);
    }

    @Override
    public String getValueString() {
        return String.valueOf(this.getValue());
    }

    @Override
    public String toString() {
        return "[AMQPTimestamp, value=" + this.getValue() + " " + super.toString() + "]";
    }
}

