/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.amqp.v100.types;

import com.swiftmq.amqp.v100.types.AMQPDescribedConstructor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public abstract class AMQPType {
    static ThreadLocal writeCodeHolder = new ThreadLocal();
    String name;
    int code;
    AMQPDescribedConstructor constructor = null;
    AMQPDescribedConstructor originalConstructor = null;

    protected AMQPType(String name, int code) {
        this.name = name;
        this.code = code;
    }

    public AMQPDescribedConstructor getConstructor() {
        return this.constructor;
    }

    public void setConstructor(AMQPDescribedConstructor constructor) {
        if (this.constructor != null) {
            this.originalConstructor = this.constructor;
        }
        this.constructor = constructor;
    }

    public void resetConstructor() {
        if (this.originalConstructor != null) {
            this.constructor = this.originalConstructor;
            this.originalConstructor = null;
        }
    }

    public String getName() {
        return this.name;
    }

    public int getCode() {
        if (this.constructor != null) {
            return 0;
        }
        return this.code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public boolean isWriteCode() {
        Boolean b = (Boolean)writeCodeHolder.get();
        return b == null ? true : b;
    }

    public void setWriteCode(boolean writeCode) {
        writeCodeHolder.set(writeCode);
    }

    public int getPredictedSize() {
        return 1 + (this.constructor == null ? 0 : this.constructor.getPredictedSize());
    }

    public boolean hasDescriptor() {
        return false;
    }

    public abstract void readContent(DataInput var1) throws IOException;

    public void writeContent(DataOutput out) throws IOException {
        if (this.isWriteCode()) {
            if (this.constructor != null) {
                this.constructor.writeContent(out);
            } else {
                out.writeByte(this.code);
            }
        }
    }

    public abstract String getValueString();

    public String toString() {
        return " [AMQPType name=" + this.name + ", code=0x" + Integer.toHexString(this.code) + ", constructor=" + this.constructor + "]";
    }
}

