/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.amqp.v100.types;

import com.swiftmq.amqp.v100.types.AMQPArray;
import com.swiftmq.amqp.v100.types.AMQPBinary;
import com.swiftmq.amqp.v100.types.AMQPBoolean;
import com.swiftmq.amqp.v100.types.AMQPByte;
import com.swiftmq.amqp.v100.types.AMQPChar;
import com.swiftmq.amqp.v100.types.AMQPDecimal128;
import com.swiftmq.amqp.v100.types.AMQPDecimal32;
import com.swiftmq.amqp.v100.types.AMQPDecimal64;
import com.swiftmq.amqp.v100.types.AMQPDescribedConstructor;
import com.swiftmq.amqp.v100.types.AMQPDouble;
import com.swiftmq.amqp.v100.types.AMQPFloat;
import com.swiftmq.amqp.v100.types.AMQPInt;
import com.swiftmq.amqp.v100.types.AMQPList;
import com.swiftmq.amqp.v100.types.AMQPLong;
import com.swiftmq.amqp.v100.types.AMQPMap;
import com.swiftmq.amqp.v100.types.AMQPNull;
import com.swiftmq.amqp.v100.types.AMQPShort;
import com.swiftmq.amqp.v100.types.AMQPString;
import com.swiftmq.amqp.v100.types.AMQPSymbol;
import com.swiftmq.amqp.v100.types.AMQPTimestamp;
import com.swiftmq.amqp.v100.types.AMQPType;
import com.swiftmq.amqp.v100.types.AMQPUnsignedByte;
import com.swiftmq.amqp.v100.types.AMQPUnsignedInt;
import com.swiftmq.amqp.v100.types.AMQPUnsignedLong;
import com.swiftmq.amqp.v100.types.AMQPUnsignedShort;
import com.swiftmq.amqp.v100.types.AMQPUuid;
import java.io.DataInput;
import java.io.IOException;

public class AMQPTypeDecoder {
    public static final int CONSTRUCTOR = 0;
    public static final int NULL = 64;
    public static final int TRUE = 65;
    public static final int FALSE = 66;
    public static final int BOOLEAN = 86;
    public static final int UBYTE = 80;
    public static final int USHORT = 96;
    public static final int UINT = 112;
    public static final int SUINT = 82;
    public static final int UINT0 = 67;
    public static final int ULONG = 128;
    public static final int SULONG = 83;
    public static final int ULONG0 = 68;
    public static final int BYTE = 81;
    public static final int SHORT = 97;
    public static final int INT = 113;
    public static final int SINT = 84;
    public static final int LONG = 129;
    public static final int SLONG = 85;
    public static final int FLOAT = 114;
    public static final int DOUBLE = 130;
    public static final int DECIMAL32 = 116;
    public static final int DECIMAL64 = 132;
    public static final int DECIMAL128 = 148;
    public static final int CHAR = 115;
    public static final int TIMESTAMP = 131;
    public static final int UUID = 152;
    public static final int BIN8 = 160;
    public static final int BIN32 = 176;
    public static final int STR8UTF8 = 161;
    public static final int STR32UTF8 = 177;
    public static final int SYM8 = 163;
    public static final int SYM32 = 179;
    public static final int LIST0 = 69;
    public static final int LIST8 = 192;
    public static final int LIST32 = 208;
    public static final int ARRAY8 = 224;
    public static final int ARRAY32 = 240;
    public static final int MAP8 = 193;
    public static final int MAP32 = 209;
    public static final int UNKNOWN = 255;

    private static boolean descriptorTypeValid(int code) {
        return code == 163 || code == 179 || code == 128 || code == 83 || code == 65;
    }

    public static boolean isString(int code) {
        return code == 161 || code == 177;
    }

    public static boolean isBoolean(int code) {
        return code == 65 || code == 66 || code == 86;
    }

    public static boolean isInt(int code) {
        return code == 113 || code == 84;
    }

    public static boolean isLong(int code) {
        return code == 129 || code == 85;
    }

    public static boolean isUInt(int code) {
        return code == 112 || code == 82 || code == 67;
    }

    public static boolean isULong(int code) {
        return code == 128 || code == 83 || code == 68;
    }

    public static boolean isSymbol(int code) {
        return code == 163 || code == 179;
    }

    public static boolean isList(int code) {
        return code == 69 || code == 192 || code == 208;
    }

    public static boolean isMap(int code) {
        return code == 193 || code == 209;
    }

    public static boolean isArray(int code) {
        return code == 224 || code == 240;
    }

    public static boolean isBinary(int code) {
        return code == 160 || code == 176;
    }

    public static AMQPType decode(DataInput in) throws IOException {
        int code = in.readUnsignedByte();
        return AMQPTypeDecoder.decode(code, in);
    }

    public static AMQPType decode(int code, DataInput in) throws IOException {
        AMQPType obj = null;
        switch (code) {
            case 0: {
                AMQPDescribedConstructor constructor = new AMQPDescribedConstructor();
                constructor.readContent(in);
                if (!AMQPTypeDecoder.descriptorTypeValid(constructor.getDescriptor().getCode())) {
                    throw new IOException("Invalid descriptor type: 0x" + Integer.toHexString(constructor.getDescriptor().getCode()) + ", must be Symbol or ULong or TRUE!");
                }
                obj = AMQPTypeDecoder.decode(constructor.getFormatCode(), in);
                obj.setConstructor(constructor);
                return obj;
            }
            case 64: {
                obj = new AMQPNull();
                break;
            }
            case 65: 
            case 66: 
            case 86: {
                obj = new AMQPBoolean(code);
                break;
            }
            case 80: {
                obj = new AMQPUnsignedByte();
                break;
            }
            case 96: {
                obj = new AMQPUnsignedShort();
                break;
            }
            case 67: 
            case 82: 
            case 112: {
                obj = new AMQPUnsignedInt();
                break;
            }
            case 68: 
            case 83: 
            case 128: {
                obj = new AMQPUnsignedLong();
                break;
            }
            case 81: {
                obj = new AMQPByte();
                break;
            }
            case 97: {
                obj = new AMQPShort();
                break;
            }
            case 84: 
            case 113: {
                obj = new AMQPInt();
                break;
            }
            case 85: 
            case 129: {
                obj = new AMQPLong();
                break;
            }
            case 114: {
                obj = new AMQPFloat();
                break;
            }
            case 130: {
                obj = new AMQPDouble();
                break;
            }
            case 116: {
                obj = new AMQPDecimal32();
                break;
            }
            case 132: {
                obj = new AMQPDecimal64();
                break;
            }
            case 148: {
                obj = new AMQPDecimal128();
                break;
            }
            case 115: {
                obj = new AMQPChar();
                break;
            }
            case 131: {
                obj = new AMQPTimestamp();
                break;
            }
            case 152: {
                obj = new AMQPUuid();
                break;
            }
            case 160: 
            case 176: {
                obj = new AMQPBinary();
                break;
            }
            case 161: 
            case 177: {
                obj = new AMQPString();
                break;
            }
            case 163: 
            case 179: {
                obj = new AMQPSymbol();
                break;
            }
            case 69: 
            case 192: 
            case 208: {
                obj = new AMQPList();
                break;
            }
            case 224: 
            case 240: {
                obj = new AMQPArray();
                break;
            }
            case 193: 
            case 209: {
                obj = new AMQPMap();
                break;
            }
            default: {
                throw new IOException("Can't decode, invalide code: 0x" + Integer.toHexString(code));
            }
        }
        obj.setCode(code);
        obj.readContent(in);
        return obj;
    }
}

