/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.amqp.v100.types;

import com.swiftmq.amqp.v100.types.AMQPType;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class AMQPUnsignedByte
extends AMQPType {
    int value;

    public AMQPUnsignedByte() {
        super("ubyte", 80);
    }

    public AMQPUnsignedByte(int value) {
        super("ubyte", 80);
        this.setValue(value);
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int value) {
        this.value = value;
    }

    @Override
    public int getPredictedSize() {
        int n = super.getPredictedSize() + 1;
        return n;
    }

    @Override
    public void readContent(DataInput in) throws IOException {
        this.value = in.readUnsignedByte();
    }

    @Override
    public void writeContent(DataOutput out) throws IOException {
        super.writeContent(out);
        out.writeByte(this.value);
    }

    @Override
    public String getValueString() {
        return Integer.toString(this.value);
    }

    @Override
    public String toString() {
        return "[AMQPUnsignedByte, value=" + this.getValue() + " " + super.toString() + "]";
    }
}

