/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.amqp.v100.types;

import com.swiftmq.amqp.v100.types.AMQPType;
import com.swiftmq.amqp.v100.types.Util;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class AMQPUnsignedInt
extends AMQPType {
    byte[] bytes = new byte[4];

    public AMQPUnsignedInt() {
        super("uint", 112);
    }

    public AMQPUnsignedInt(long value) {
        super("uint", 112);
        this.setValue(value);
    }

    public long getValue() {
        if (this.code == 112) {
            return (long)Util.readInt(this.bytes, 0) & 0xFFFFFFFFL;
        }
        if (this.code == 82) {
            return this.bytes[0] & 0xFF;
        }
        return 0L;
    }

    public void setValue(long value) {
        Util.writeInt((int)value, this.bytes, 0);
        this.code = value == 0L ? 67 : 112;
    }

    @Override
    public int getPredictedSize() {
        int n = super.getPredictedSize();
        if (this.code == 112) {
            n += 4;
        } else if (this.code == 82) {
            ++n;
        }
        return n;
    }

    @Override
    public void readContent(DataInput in) throws IOException {
        if (this.code == 112) {
            in.readFully(this.bytes);
        } else if (this.code == 82) {
            this.bytes[0] = in.readByte();
        } else if (this.code != 67) {
            throw new IOException("Invalid code: " + this.code);
        }
    }

    @Override
    public void writeContent(DataOutput out) throws IOException {
        super.writeContent(out);
        if (this.code == 112) {
            out.write(this.bytes);
        } else if (this.code == 82) {
            out.writeByte(this.bytes[0]);
        }
    }

    @Override
    public String getValueString() {
        return Long.toString(this.getValue());
    }

    @Override
    public String toString() {
        return "[AMQPUnsignedInt, value=" + this.getValue() + " " + super.toString() + "]";
    }
}

