/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.amqp.v100.types;

import com.swiftmq.amqp.v100.types.AMQPType;
import com.swiftmq.amqp.v100.types.Util;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class AMQPUnsignedLong
extends AMQPType {
    byte[] bytes = new byte[8];

    public AMQPUnsignedLong() {
        super("ulong", 128);
    }

    public AMQPUnsignedLong(long value) {
        super("ulong", 128);
        this.setValue(value);
    }

    public long getValue() {
        if (this.code == 128) {
            return Util.readLong(this.bytes, 0);
        }
        if (this.code == 83) {
            return (long)this.bytes[0] & 0xFFL;
        }
        return 0L;
    }

    public void setValue(long value) {
        Util.writeLong(value, this.bytes, 0);
        this.code = value == 0L ? 68 : 128;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    @Override
    public int getPredictedSize() {
        int n = super.getPredictedSize();
        if (this.code == 128) {
            n += 8;
        } else if (this.code == 83) {
            ++n;
        }
        return n;
    }

    @Override
    public void readContent(DataInput in) throws IOException {
        if (this.code == 128) {
            in.readFully(this.bytes);
        } else if (this.code == 83) {
            this.bytes[0] = in.readByte();
        } else if (this.code != 68) {
            throw new IOException("Invalid code: " + this.code);
        }
    }

    @Override
    public void writeContent(DataOutput out) throws IOException {
        super.writeContent(out);
        if (this.code == 128) {
            out.write(this.bytes);
        } else if (this.code == 83) {
            out.writeByte(this.bytes[0]);
        }
    }

    @Override
    public String getValueString() {
        return Long.toString(this.getValue());
    }

    @Override
    public String toString() {
        return "[AMQPUnsignedLong, value=" + this.getValue() + " " + super.toString() + "]";
    }
}

