/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.amqp.v100.types;

import com.swiftmq.amqp.v100.types.AMQPType;
import com.swiftmq.amqp.v100.types.Util;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class AMQPUnsignedShort
extends AMQPType {
    byte[] bytes = new byte[2];

    public AMQPUnsignedShort() {
        super("ushort", 96);
    }

    public AMQPUnsignedShort(int value) {
        super("ushort", 96);
        this.setValue(value);
    }

    public int getValue() {
        return Util.readUnsignedShort(this.bytes, 0);
    }

    public void setValue(int value) {
        Util.writeShort(value, this.bytes, 0);
    }

    @Override
    public int getPredictedSize() {
        int n = super.getPredictedSize() + this.bytes.length;
        return n;
    }

    @Override
    public void readContent(DataInput in) throws IOException {
        in.readFully(this.bytes);
    }

    @Override
    public void writeContent(DataOutput out) throws IOException {
        super.writeContent(out);
        out.write(this.bytes);
    }

    @Override
    public String getValueString() {
        return Integer.toString(this.getValue());
    }

    @Override
    public String toString() {
        return "[AMQPUnsignedShort, value=" + this.getValue() + " " + super.toString() + "]";
    }
}

