/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.amqp.v100.types;

import com.swiftmq.amqp.v100.types.AMQPType;
import com.swiftmq.amqp.v100.types.Util;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.UUID;

public class AMQPUuid
extends AMQPType {
    byte[] bytes;

    public AMQPUuid() {
        super("uuid", 152);
    }

    public AMQPUuid(UUID value) {
        this(value.getMostSignificantBits(), value.getLeastSignificantBits());
    }

    public AMQPUuid(long mostSigBits, long leastSigBits) {
        super("uuid", 152);
        this.setValue(mostSigBits, leastSigBits);
    }

    public void setValue(long mostSigBits, long leastSigBits) {
        this.bytes = new byte[16];
        Util.writeLong(mostSigBits, this.bytes, 0);
        Util.writeLong(leastSigBits, this.bytes, 8);
    }

    public UUID getValue() {
        return new UUID(Util.readLong(this.bytes, 0), Util.readLong(this.bytes, 8));
    }

    @Override
    public int getPredictedSize() {
        int n = super.getPredictedSize() + 16;
        return n;
    }

    @Override
    public void readContent(DataInput in) throws IOException {
        this.bytes = new byte[16];
        in.readFully(this.bytes);
    }

    @Override
    public void writeContent(DataOutput out) throws IOException {
        super.writeContent(out);
        out.write(this.bytes);
    }

    @Override
    public String getValueString() {
        return this.getValue().toString();
    }

    @Override
    public String toString() {
        return "[AMQPUuid, UUID=" + this.getValue() + ", bytes.length=" + (this.bytes == null ? "null" : Integer.valueOf(this.bytes.length)) + " " + super.toString() + "]";
    }

    public static void main(String[] args) {
        UUID uuid = UUID.fromString("7d146cc0-7995-11ea-ab12-0800200c9a66");
        AMQPUuid amqpUuid = new AMQPUuid(uuid);
        System.out.println(uuid);
        System.out.println(amqpUuid.getValue());
    }
}

