/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.amqp.v100.types;

import com.swiftmq.amqp.ProtocolHeader;
import java.util.List;

public class Util {
    public static final ProtocolHeader SASL_INIT = new ProtocolHeader("AMQP", 3, 1, 0, 0);
    public static final ProtocolHeader AMQP_INIT = new ProtocolHeader("AMQP", 0, 1, 0, 0);

    public static void ensureSize(List list, int size) {
        if (list.size() < size + 1) {
            for (int i = list.size(); i < size + 1; ++i) {
                list.add(null);
            }
        }
    }

    public static List addToList(List list, Object[] obj) {
        for (int i = 0; i < obj.length; ++i) {
            list.add(obj[i]);
        }
        return list;
    }

    public static String toHex(byte[] bytes, int len) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            sb.append(String.format("0x%1$02X ", bytes[i]));
        }
        return sb.toString();
    }

    public static short readShort(byte[] b, int offset) {
        int pos = offset;
        int i1 = b[pos++] & 0xFF;
        int i2 = b[pos++] & 0xFF;
        return (short)((i1 << 8) + (i2 << 0));
    }

    public static int readUnsignedShort(byte[] b, int offset) {
        int pos = offset;
        int i1 = b[pos++] & 0xFF;
        int i2 = b[pos++] & 0xFF;
        return (i1 << 8) + (i2 << 0);
    }

    public static int readInt(byte[] b, int offset) {
        int pos = offset;
        int i1 = b[pos++] & 0xFF;
        int i2 = b[pos++] & 0xFF;
        int i3 = b[pos++] & 0xFF;
        int i4 = b[pos++] & 0xFF;
        int i = (i1 << 24) + (i2 << 16) + (i3 << 8) + (i4 << 0);
        return i;
    }

    public static long readLong(byte[] b, int offset) {
        long l = ((long)Util.readInt(b, offset) << 32) + ((long)Util.readInt(b, offset + 4) & 0xFFFFFFFFL);
        return l;
    }

    public static float readFloat(byte[] b, int offset) {
        return Float.intBitsToFloat(Util.readInt(b, offset));
    }

    public static double readDouble(byte[] b, int offset) {
        return Double.longBitsToDouble(Util.readLong(b, offset));
    }

    public static void writeShort(int s, byte[] b, int offset) {
        int pos = offset;
        b[pos++] = (byte)(s >>> 8 & 0xFF);
        b[pos++] = (byte)(s >>> 0 & 0xFF);
    }

    public static void writeInt(int i, byte[] b, int offset) {
        int pos = offset;
        b[pos++] = (byte)(i >>> 24 & 0xFF);
        b[pos++] = (byte)(i >>> 16 & 0xFF);
        b[pos++] = (byte)(i >>> 8 & 0xFF);
        b[pos++] = (byte)(i >>> 0 & 0xFF);
    }

    public static void writeLong(long l, byte[] b, int offset) {
        int pos = offset;
        b[pos++] = (byte)(l >>> 56 & 0xFFL);
        b[pos++] = (byte)(l >>> 48 & 0xFFL);
        b[pos++] = (byte)(l >>> 40 & 0xFFL);
        b[pos++] = (byte)(l >>> 32 & 0xFFL);
        b[pos++] = (byte)(l >>> 24 & 0xFFL);
        b[pos++] = (byte)(l >>> 16 & 0xFFL);
        b[pos++] = (byte)(l >>> 8 & 0xFFL);
        b[pos++] = (byte)(l >>> 0 & 0xFFL);
    }

    public static void writeFloat(float v, byte[] b, int offset) {
        Util.writeInt(Float.floatToIntBits(v), b, offset);
    }

    public static void writeDouble(double v, byte[] b, int offset) {
        Util.writeLong(Double.doubleToLongBits(v), b, offset);
    }
}

