/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.client.thread;

import com.swiftmq.client.thread.PoolManager;
import com.swiftmq.client.thread.ThreadPoolImpl;
import com.swiftmq.swiftlet.threadpool.ThreadPool;
import com.swiftmq.tools.prop.SystemProperties;

public class DefaultPoolManager
extends PoolManager {
    public static final String PROP_CONNECTOR_POOL_MIN_THREADS = "swiftmq.pool.connector.threads.min";
    public static final String PROP_CONNECTOR_POOL_MAX_THREADS = "swiftmq.pool.connector.threads.max";
    public static final String PROP_CONNECTOR_POOL_PRIO = "swiftmq.pool.connector.priority";
    public static final String PROP_CONNECTOR_POOL_QUEUE_LEN = "swiftmq.pool.connector.queue.length";
    public static final String PROP_CONNECTOR_POOL_THREADS_ADD = "swiftmq.pool.connector.threads.add";
    public static final String PROP_CONNECTOR_POOL_IDLE_TIMEOUT = "swiftmq.pool.connector.idle.timeout";
    public static final String PROP_CONN_POOL_MIN_THREADS = "swiftmq.pool.connection.threads.min";
    public static final String PROP_CONN_POOL_MAX_THREADS = "swiftmq.pool.connection.threads.max";
    public static final String PROP_CONN_POOL_PRIO = "swiftmq.pool.connection.priority";
    public static final String PROP_CONN_POOL_QUEUE_LEN = "swiftmq.pool.connection.queue.length";
    public static final String PROP_CONN_POOL_THREADS_ADD = "swiftmq.pool.connection.threads.add";
    public static final String PROP_CONN_POOL_IDLE_TIMEOUT = "swiftmq.pool.connection.idle.timeout";
    public static final String PROP_SESSION_POOL_MIN_THREADS = "swiftmq.pool.session.threads.min";
    public static final String PROP_SESSION_POOL_MAX_THREADS = "swiftmq.pool.session.threads.max";
    public static final String PROP_SESSION_POOL_PRIO = "swiftmq.pool.session.priority";
    public static final String PROP_SESSION_POOL_QUEUE_LEN = "swiftmq.pool.session.queue.length";
    public static final String PROP_SESSION_POOL_THREADS_ADD = "swiftmq.pool.session.threads.add";
    public static final String PROP_SESSION_POOL_IDLE_TIMEOUT = "swiftmq.pool.session.idle.timeout";
    ThreadPool connectionPool = null;
    ThreadPool sessionPool = null;
    ThreadPool connectorPool = null;

    @Override
    public synchronized ThreadPool getConnectionPool() {
        if (this.connectionPool == null) {
            int min = Integer.parseInt(SystemProperties.get(PROP_CONN_POOL_MIN_THREADS, "5"));
            int max = Integer.parseInt(SystemProperties.get(PROP_CONN_POOL_MAX_THREADS, "50"));
            int len = Integer.parseInt(SystemProperties.get(PROP_CONN_POOL_QUEUE_LEN, "1"));
            int add = Integer.parseInt(SystemProperties.get(PROP_CONN_POOL_THREADS_ADD, "1"));
            int prio = Integer.parseInt(SystemProperties.get(PROP_CONN_POOL_PRIO, String.valueOf(5)));
            long timeout = Long.parseLong(SystemProperties.get(PROP_CONN_POOL_IDLE_TIMEOUT, "120000"));
            this.connectionPool = new ThreadPoolImpl("ConnectionPool", true, min, max, len, add, prio, timeout);
        }
        return this.connectionPool;
    }

    @Override
    public synchronized ThreadPool getSessionPool() {
        if (this.sessionPool == null) {
            int min = Integer.parseInt(SystemProperties.get(PROP_SESSION_POOL_MIN_THREADS, "5"));
            int max = Integer.parseInt(SystemProperties.get(PROP_SESSION_POOL_MAX_THREADS, "50"));
            int len = Integer.parseInt(SystemProperties.get(PROP_SESSION_POOL_QUEUE_LEN, "1"));
            int add = Integer.parseInt(SystemProperties.get(PROP_SESSION_POOL_THREADS_ADD, "1"));
            int prio = Integer.parseInt(SystemProperties.get(PROP_SESSION_POOL_PRIO, String.valueOf(5)));
            long timeout = Long.parseLong(SystemProperties.get(PROP_SESSION_POOL_IDLE_TIMEOUT, "120000"));
            this.sessionPool = new ThreadPoolImpl("SessionPool", true, min, max, len, add, prio, timeout);
        }
        return this.sessionPool;
    }

    @Override
    public synchronized ThreadPool getConnectorPool() {
        if (this.connectorPool == null) {
            int min = Integer.parseInt(SystemProperties.get(PROP_CONNECTOR_POOL_MIN_THREADS, "1"));
            int max = Integer.parseInt(SystemProperties.get(PROP_CONNECTOR_POOL_MAX_THREADS, "10"));
            int len = Integer.parseInt(SystemProperties.get(PROP_CONNECTOR_POOL_QUEUE_LEN, "1"));
            int add = Integer.parseInt(SystemProperties.get(PROP_CONNECTOR_POOL_THREADS_ADD, "1"));
            int prio = Integer.parseInt(SystemProperties.get(PROP_CONNECTOR_POOL_PRIO, String.valueOf(5)));
            long timeout = Long.parseLong(SystemProperties.get(PROP_CONNECTOR_POOL_IDLE_TIMEOUT, "120000"));
            this.connectorPool = new ThreadPoolImpl("ConnectorPool", true, min, max, len, add, prio, timeout);
        }
        return this.connectorPool;
    }
}

