/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.client.thread;

import com.swiftmq.client.thread.PoolExecutor;
import com.swiftmq.swiftlet.threadpool.AsyncTask;
import com.swiftmq.swiftlet.threadpool.ThreadPool;
import com.swiftmq.swiftlet.threadpool.event.FreezeCompletionListener;
import com.swiftmq.tools.collection.RingBuffer;
import java.util.HashSet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class ThreadPoolImpl
implements ThreadPool {
    private static final int BUCKET_SIZE = 200;
    String poolName = null;
    ThreadGroup threadGroup;
    boolean daemonThreads = false;
    int minThreads;
    int maxThreads;
    int threshold;
    int addThreads;
    int priority;
    long idleTimeout;
    HashSet threadsList = new HashSet();
    int runningCount = 0;
    int idleCount = 0;
    boolean closed = false;
    RingBuffer taskList = null;
    String tname = null;
    int tcount = 0;
    Lock lock = new ReentrantLock();
    Condition taskAvail = null;

    public ThreadPoolImpl(String poolName, boolean daemonThreads, int minThreads, int maxThreads, int threshold, int addThreads, int priority, long idleTimeout) {
        this.daemonThreads = daemonThreads;
        this.poolName = poolName;
        this.minThreads = minThreads;
        this.maxThreads = maxThreads;
        this.threshold = threshold;
        this.addThreads = addThreads;
        this.priority = priority;
        this.idleTimeout = idleTimeout;
        this.taskAvail = this.lock.newCondition();
        this.tname = "SwiftMQ-" + poolName + "-";
        this.taskList = new RingBuffer(200);
        try {
            this.threadGroup = new ThreadGroup(poolName);
            this.threadGroup.setMaxPriority(priority);
        }
        catch (Exception e) {
            this.threadGroup = null;
        }
        for (int i = 0; i < minThreads; ++i) {
            this.createNewThread(-1L);
        }
    }

    private void createNewThread(long threadTimeout) {
        PoolExecutor pt = new PoolExecutor(this.tname + ++this.tcount, this.threadGroup, this, threadTimeout);
        pt.setDaemon(this.daemonThreads);
        ++this.runningCount;
        this.threadsList.add(pt);
        pt.start();
    }

    @Override
    public String getPoolName() {
        return this.poolName;
    }

    @Override
    public int getNumberRunningThreads() {
        this.lock.lock();
        try {
            int n = this.runningCount;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public int getNumberIdlingThreads() {
        this.lock.lock();
        try {
            int n = this.idleCount;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispatchTask(AsyncTask task) {
        this.lock.lock();
        try {
            if (this.closed) {
                return;
            }
            this.taskList.add(task);
            int running = this.runningCount;
            int act = this.idleCount + running;
            if (act < this.maxThreads || this.maxThreads == -1) {
                if (this.idleCount == 0 && this.taskList.getSize() - this.idleCount >= this.threshold) {
                    for (int i = 0; i < this.addThreads; ++i) {
                        this.createNewThread(this.idleTimeout);
                    }
                } else if (act == 0) {
                    this.createNewThread(this.idleTimeout);
                }
            }
            if (this.idleCount > 0) {
                this.taskAvail.signal();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AsyncTask getNextTask(PoolExecutor pt, long timeout) {
        this.lock.lock();
        try {
            --this.runningCount;
            Object task = null;
            if (this.taskList.getSize() == 0 && !this.closed) {
                ++this.idleCount;
                try {
                    if (timeout > 0L) {
                        long waitStart = System.currentTimeMillis();
                        do {
                            this.taskAvail.await(timeout, TimeUnit.MILLISECONDS);
                        } while (this.taskList.getSize() == 0 && !this.closed && System.currentTimeMillis() - waitStart < timeout);
                    } else {
                        do {
                            this.taskAvail.await();
                        } while (this.taskList.getSize() == 0 && !this.closed);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                --this.idleCount;
            }
            if (this.closed || this.taskList.getSize() == 0) {
                this.threadsList.remove(pt);
                AsyncTask asyncTask = null;
                return asyncTask;
            }
            ++this.runningCount;
            AsyncTask asyncTask = (AsyncTask)this.taskList.remove();
            return asyncTask;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void freeze(FreezeCompletionListener listener) {
    }

    @Override
    public void unfreeze() {
    }

    @Override
    public void stop() {
    }

    @Override
    public void close() {
        this.lock.lock();
        try {
            this.closed = true;
            for (PoolExecutor t : this.threadsList) {
                t.die();
            }
            this.threadsList.clear();
            this.taskList.clear();
            this.taskAvail.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }
}

