/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.filetransfer;

import com.swiftmq.filetransfer.FiletransferException;
import com.swiftmq.filetransfer.JMSAccessorHolder;
import com.swiftmq.filetransfer.ProgressListener;
import com.swiftmq.filetransfer.Util;
import com.swiftmq.filetransfer.protocol.MessageBasedFactory;
import com.swiftmq.filetransfer.protocol.MessageBasedReply;
import com.swiftmq.filetransfer.protocol.MessageBasedRequest;
import com.swiftmq.filetransfer.protocol.ProtocolFactory;
import com.swiftmq.filetransfer.protocol.ProtocolReply;
import com.swiftmq.filetransfer.protocol.ProtocolRequest;
import com.swiftmq.filetransfer.v940.FiletransferImpl;
import com.swiftmq.filetransfer.v940.LinkParser;
import com.swiftmq.jms.SwiftMQConnection;
import com.swiftmq.tools.requestreply.RequestRegistry;
import java.io.File;
import java.util.List;
import java.util.Map;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;

public abstract class Filetransfer {
    private static final int PROTOCOL_VERSION = Integer.parseInt(System.getProperty("swiftmq.filetransfer.protocol.version", "941"));

    protected Filetransfer() {
    }

    public static Filetransfer create(Connection connection, String routerName, String cacheName) throws FiletransferException, JMSException {
        return Filetransfer.createAndSetup(connection, routerName, cacheName);
    }

    public static Filetransfer create(Connection connection, String link) throws FiletransferException, JMSException {
        LinkParser linkParser = new LinkParser(link);
        return Filetransfer.createAndSetup(connection, linkParser.getRouterName(), linkParser.getCacheName()).withLink(link);
    }

    private static Filetransfer createAndSetup(Connection connection, String routerName, String cacheName) throws FiletransferException, JMSException {
        JMSAccessorHolder accessorHolder = new JMSAccessorHolder();
        accessorHolder.username = ((SwiftMQConnection)connection).getUserName();
        accessorHolder.session = connection.createSession(false, 1);
        accessorHolder.replyQueue = accessorHolder.session.createTemporaryQueue();
        accessorHolder.producer = accessorHolder.session.createProducer((Destination)accessorHolder.session.createQueue(Util.createCacheRequestQueueName(cacheName, routerName)));
        accessorHolder.producer.setDeliveryMode(1);
        accessorHolder.consumer = accessorHolder.session.createConsumer((Destination)accessorHolder.replyQueue);
        ProtocolReply reply = (ProtocolReply)Filetransfer.request(new ProtocolRequest(PROTOCOL_VERSION), accessorHolder, new ProtocolFactory());
        Filetransfer filetransfer = null;
        if (reply.isOk()) {
            accessorHolder.producer.close();
            accessorHolder.producer = accessorHolder.session.createProducer((Destination)accessorHolder.session.createQueue(reply.getQueueName()));
            switch (PROTOCOL_VERSION) {
                case 940: {
                    filetransfer = new FiletransferImpl(accessorHolder);
                    break;
                }
                case 941: {
                    filetransfer = new com.swiftmq.filetransfer.v941.FiletransferImpl(accessorHolder);
                }
            }
        } else {
            throw new FiletransferException(reply.getException());
        }
        return filetransfer;
    }

    protected static MessageBasedReply request(MessageBasedRequest request, JMSAccessorHolder accessorHolder, MessageBasedFactory factory) throws FiletransferException, JMSException {
        return Filetransfer.request(request, accessorHolder, factory, null);
    }

    protected static MessageBasedReply request(MessageBasedRequest request, JMSAccessorHolder accessorHolder, MessageBasedFactory factory, Map<String, Object> properties) throws FiletransferException, JMSException {
        Message msg = request.toMessage();
        msg.setJMSReplyTo((Destination)accessorHolder.replyQueue);
        if (properties != null) {
            for (Map.Entry<String, Object> entry : properties.entrySet()) {
                msg.setObjectProperty(entry.getKey(), entry.getValue());
            }
        }
        accessorHolder.producer.send(msg);
        if (!request.isReplyRequired()) {
            return null;
        }
        msg = accessorHolder.consumer.receive(RequestRegistry.SWIFTMQ_REQUEST_TIMEOUT);
        if (msg == null) {
            throw new JMSException("Request timeout occured (" + RequestRegistry.SWIFTMQ_REQUEST_TIMEOUT + ") ms");
        }
        return (MessageBasedReply)factory.create(msg);
    }

    public abstract Filetransfer withFile(File var1);

    public abstract Filetransfer withFilename(String var1);

    public abstract Filetransfer withOutputDirectory(File var1);

    public abstract Filetransfer withOriginalFilename(boolean var1);

    public abstract Filetransfer withLink(String var1);

    public abstract Filetransfer withDigestType(String var1);

    public abstract Filetransfer withDeleteAfterNumberDownloads(int var1);

    public abstract Filetransfer withPassword(String var1);

    public abstract Filetransfer withPasswordHexDigest(String var1);

    public abstract Filetransfer withExpiration(long var1);

    public abstract Filetransfer withFileIsPrivate(boolean var1);

    public abstract Filetransfer withProperties(Map<String, Object> var1);

    public abstract Filetransfer withSelector(String var1);

    public abstract Filetransfer withReplyInterval(int var1);

    public abstract String send(ProgressListener var1) throws Exception;

    public abstract String send() throws Exception;

    public abstract Filetransfer receive(ProgressListener var1) throws Exception;

    public abstract Filetransfer receive() throws Exception;

    public abstract Filetransfer delete() throws Exception;

    public abstract List<String> query() throws Exception;

    public abstract Map<String, Map<String, Object>> queryProperties() throws Exception;

    public abstract void close();
}

