/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.filetransfer.protocol;

import com.swiftmq.filetransfer.protocol.MessageBased;
import javax.jms.JMSException;
import javax.jms.Message;

public abstract class MessageBasedReply
implements MessageBased {
    public static final String OK_PROP = "JMS_SWIFTMQ_FT_OK";
    public static final String EXCEPTION_PROP = "JMS_SWIFTMQ_FT_EXCEPTION";
    boolean ok = true;
    String exception = null;

    protected MessageBasedReply() {
    }

    protected MessageBasedReply(Message message) throws JMSException {
        if (message.propertyExists(OK_PROP)) {
            this.ok = message.getBooleanProperty(OK_PROP);
        }
        if (!this.ok) {
            this.exception = message.getStringProperty(EXCEPTION_PROP);
        }
    }

    public boolean isOk() {
        return this.ok;
    }

    public void setOk(boolean ok) {
        this.ok = ok;
    }

    public String getException() {
        return this.exception;
    }

    public void setException(String exception) {
        this.exception = exception;
    }

    public Message fillMessage(Message message) throws JMSException {
        message.setBooleanProperty(OK_PROP, this.ok);
        message.setStringProperty(EXCEPTION_PROP, this.exception);
        return message;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("[MessageBasedReply");
        sb.append(", ok=").append(this.ok);
        sb.append(", exception=").append(this.exception);
        sb.append("]");
        return sb.toString();
    }
}

