/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.filetransfer.protocol;

import com.swiftmq.filetransfer.protocol.MessageBased;
import com.swiftmq.filetransfer.protocol.MessageBasedFactory;
import com.swiftmq.filetransfer.protocol.ProtocolReply;
import com.swiftmq.filetransfer.protocol.ProtocolRequest;
import javax.jms.JMSException;
import javax.jms.Message;

public class ProtocolFactory
implements MessageBasedFactory {
    public static final String DUMPID_PROP = "JMS_SWIFTMQ_FT_DUMPID";
    public static final int PROTOCOL_REQ = 0;
    public static final int PROTOCOL_REP = 1;
    MessageBasedFactory delegatedFactory = null;

    public ProtocolFactory() {
    }

    public ProtocolFactory(MessageBasedFactory delegatedFactory) {
        this.delegatedFactory = delegatedFactory;
    }

    public void setDelegatedFactory(MessageBasedFactory delegatedFactory) {
        this.delegatedFactory = delegatedFactory;
    }

    @Override
    public MessageBased create(Message message) throws JMSException {
        MessageBased messageBased = null;
        int dumpId = message.getIntProperty(DUMPID_PROP);
        switch (dumpId) {
            case 0: {
                messageBased = new ProtocolRequest(message);
                break;
            }
            case 1: {
                messageBased = new ProtocolReply(message);
                break;
            }
            default: {
                if (this.delegatedFactory == null) break;
                messageBased = this.delegatedFactory.create(message);
            }
        }
        return messageBased;
    }
}

