/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.filetransfer.protocol;

import com.swiftmq.filetransfer.protocol.MessageBasedReply;
import com.swiftmq.filetransfer.protocol.MessageBasedRequest;
import com.swiftmq.filetransfer.protocol.MessageBasedRequestVisitor;
import com.swiftmq.filetransfer.protocol.ProtocolReply;
import com.swiftmq.filetransfer.protocol.ProtocolVisitor;
import com.swiftmq.jms.MessageImpl;
import javax.jms.JMSException;
import javax.jms.Message;

public class ProtocolRequest
extends MessageBasedRequest {
    public static final String VERSION_PROP = "JMS_SWIFTMQ_FT_VERSION";
    int version = 0;

    public ProtocolRequest(int version) {
        this.version = version;
        this.setReplyRequired(true);
    }

    public ProtocolRequest(Message message) throws JMSException {
        this(message.getIntProperty(VERSION_PROP));
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    @Override
    public MessageBasedReply createReplyInstance() {
        return new ProtocolReply();
    }

    @Override
    public void accept(MessageBasedRequestVisitor visitor) {
        ((ProtocolVisitor)visitor).visit(this);
    }

    @Override
    public Message toMessage() throws JMSException {
        MessageImpl message = new MessageImpl();
        message.setIntProperty("JMS_SWIFTMQ_FT_DUMPID", 0);
        message.setIntProperty(VERSION_PROP, this.version);
        return message;
    }

    @Override
    public String toString() {
        return "[ProtocolRequest, version=" + this.version + "]";
    }
}

