/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.filetransfer.protocol.v940;

import com.swiftmq.filetransfer.protocol.MessageBasedReply;
import com.swiftmq.jms.TextMessageImpl;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.TextMessage;

public class FileChunkReply
extends MessageBasedReply {
    public static final String CHUNKNO_PROP = "JMS_SWIFTMQ_FT_CHUNKNO";
    int chunkNo = 0;
    String link = null;

    public FileChunkReply(Message message) throws JMSException {
        super(message);
        this.chunkNo = message.getIntProperty(CHUNKNO_PROP);
        this.link = ((TextMessage)message).getText();
    }

    public FileChunkReply() {
    }

    public int getChunkNo() {
        return this.chunkNo;
    }

    public void setChunkNo(int chunkNo) {
        this.chunkNo = chunkNo;
    }

    public String getLink() {
        return this.link;
    }

    public void setLink(String link) {
        this.link = link;
    }

    @Override
    public Message toMessage() throws JMSException {
        TextMessageImpl message = new TextMessageImpl();
        message.setIntProperty("JMS_SWIFTMQ_FT_DUMPID", 5);
        message.setIntProperty(CHUNKNO_PROP, this.chunkNo);
        if (this.link != null) {
            message.setText(this.link);
        }
        return this.fillMessage(message);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[FileChunkReply");
        sb.append(super.toString());
        sb.append(" chunkNo='").append(this.chunkNo).append('\'');
        sb.append(" link='").append(this.link).append('\'');
        sb.append(']');
        return sb.toString();
    }
}

