/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.filetransfer.protocol.v940;

import com.swiftmq.filetransfer.protocol.MessageBasedReply;
import com.swiftmq.filetransfer.protocol.MessageBasedRequest;
import com.swiftmq.filetransfer.protocol.MessageBasedRequestVisitor;
import com.swiftmq.filetransfer.protocol.v940.FileChunkReply;
import com.swiftmq.filetransfer.protocol.v940.ProtocolVisitor;
import com.swiftmq.jms.BytesMessageImpl;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.Message;

public class FileChunkRequest
extends MessageBasedRequest {
    public static final String CHUNKNO_PROP = "JMS_SWIFTMQ_FT_CHUNKNO";
    public static final String LENGTH_PROP = "JMS_SWIFTMQ_FT_LENGTH";
    public static final String LAST_PROP = "JMS_SWIFTMQ_FT_LAST";
    int chunkNo = 0;
    byte[] chunk = null;
    int len = 0;
    boolean last = false;

    public FileChunkRequest(Message message) throws JMSException {
        super(message);
        this.chunkNo = message.getIntProperty(CHUNKNO_PROP);
        this.len = message.getIntProperty(LENGTH_PROP);
        this.last = message.getBooleanProperty(LAST_PROP);
        this.chunk = new byte[this.len];
        ((BytesMessage)message).readBytes(this.chunk);
    }

    public FileChunkRequest(boolean replyRequired, int chunkNo, boolean last, byte[] chunk, int len) {
        this.setReplyRequired(replyRequired);
        this.chunkNo = chunkNo;
        this.last = last;
        this.len = len;
        this.chunk = new byte[len];
        System.arraycopy(chunk, 0, this.chunk, 0, len);
    }

    public int getChunkNo() {
        return this.chunkNo;
    }

    public byte[] getChunk() {
        return this.chunk;
    }

    public int getLen() {
        return this.len;
    }

    public boolean isLast() {
        return this.last;
    }

    @Override
    public MessageBasedReply createReplyInstance() {
        if (this.isReplyRequired()) {
            return new FileChunkReply();
        }
        return null;
    }

    @Override
    public void accept(MessageBasedRequestVisitor visitor) {
        ((ProtocolVisitor)visitor).visit(this);
    }

    @Override
    public Message toMessage() throws JMSException {
        BytesMessageImpl message = new BytesMessageImpl();
        this.fillMessage(message);
        message.setIntProperty("JMS_SWIFTMQ_FT_DUMPID", 4);
        message.setIntProperty(CHUNKNO_PROP, this.chunkNo);
        message.setIntProperty(LENGTH_PROP, this.len);
        message.setBooleanProperty(LAST_PROP, this.last);
        message.writeBytes(this.chunk, 0, this.len);
        return message;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[FileChunkRequest");
        sb.append(super.toString());
        sb.append(" chunkNo=").append(this.chunkNo);
        sb.append(", last=").append(this.last);
        sb.append(", len=").append(this.len);
        sb.append(']');
        return sb.toString();
    }
}

