/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.filetransfer.protocol.v940;

import com.swiftmq.filetransfer.protocol.MessageBasedReply;
import com.swiftmq.jms.MessageImpl;
import javax.jms.JMSException;
import javax.jms.Message;

public class FileConsumeReply
extends MessageBasedReply {
    public static final String FILENAME_PROP = "JMS_SWIFTMQ_FT_FILENAME";
    public static final String SIZE_PROP = "JMS_SWIFTMQ_FT_SIZE";
    public static final String CHUNKLENGTH_PROP = "JMS_SWIFTMQ_FT_CHUNKLENGTH";
    String filename = null;
    int chunkLength = 0;
    long size = 0L;

    public FileConsumeReply(Message message) throws JMSException {
        super(message);
        this.filename = message.getStringProperty(FILENAME_PROP);
        this.chunkLength = message.getIntProperty(CHUNKLENGTH_PROP);
        this.size = message.getLongProperty(SIZE_PROP);
    }

    public FileConsumeReply(String filename, int chunkLength, long size) {
        this.filename = filename;
        this.size = size;
    }

    public FileConsumeReply() {
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public int getChunkLength() {
        return this.chunkLength;
    }

    public void setChunkLength(int chunkLength) {
        this.chunkLength = chunkLength;
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(long size) {
        this.size = size;
    }

    @Override
    public Message toMessage() throws JMSException {
        MessageImpl message = new MessageImpl();
        message.setIntProperty("JMS_SWIFTMQ_FT_DUMPID", 3);
        message.setStringProperty(FILENAME_PROP, this.filename);
        message.setIntProperty(CHUNKLENGTH_PROP, this.chunkLength);
        message.setLongProperty(SIZE_PROP, this.size);
        return this.fillMessage(message);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[FileConsumeReply");
        sb.append(super.toString());
        sb.append(", filename='").append(this.filename).append('\'');
        sb.append(", chunkLength=").append(this.chunkLength);
        sb.append(", size=").append(this.size);
        sb.append(']');
        return sb.toString();
    }
}

