/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.filetransfer.protocol.v940;

import com.swiftmq.filetransfer.protocol.MessageBasedReply;
import com.swiftmq.filetransfer.protocol.MessageBasedRequest;
import com.swiftmq.filetransfer.protocol.MessageBasedRequestVisitor;
import com.swiftmq.filetransfer.protocol.v940.FileConsumeReply;
import com.swiftmq.filetransfer.protocol.v940.ProtocolVisitor;
import com.swiftmq.jms.TextMessageImpl;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.TextMessage;

public class FileConsumeRequest
extends MessageBasedRequest {
    public static final String QUEUENAME_PROP = "JMS_SWIFTMQ_FT_QUEUENAME";
    public static final String REPLYINTERVAL_PROP = "JMS_SWIFTMQ_FT_REPLYINTERVAL";
    public static final String PWDHEXDIGEST_PROP = "JMS_SWIFTMQ_FT_PWDHEXDIGEST";
    String queueName = null;
    String link = null;
    String passwordHexDigest = null;
    int replyInterval = 0;

    public FileConsumeRequest(Message message) throws JMSException {
        super(message);
        this.queueName = message.getStringProperty(QUEUENAME_PROP);
        this.replyInterval = message.getIntProperty(REPLYINTERVAL_PROP);
        if (message.propertyExists(PWDHEXDIGEST_PROP)) {
            this.passwordHexDigest = message.getStringProperty(PWDHEXDIGEST_PROP);
        }
        this.link = ((TextMessage)message).getText();
    }

    public FileConsumeRequest(String queueName, String link, String passwordHexDigest, int replyInterval) {
        this.setReplyRequired(true);
        this.queueName = queueName;
        this.link = link;
        this.passwordHexDigest = passwordHexDigest;
        this.replyInterval = replyInterval;
    }

    public String getQueueName() {
        return this.queueName;
    }

    public void setQueueName(String queueName) {
        this.queueName = queueName;
    }

    public String getLink() {
        return this.link;
    }

    public void setLink(String link) {
        this.link = link;
    }

    public int getReplyInterval() {
        return this.replyInterval;
    }

    public void setReplyInterval(int replyInterval) {
        this.replyInterval = replyInterval;
    }

    public String getPasswordHexDigest() {
        return this.passwordHexDigest;
    }

    public void setPasswordHexDigest(String passwordHexDigest) {
        this.passwordHexDigest = passwordHexDigest;
    }

    @Override
    public MessageBasedReply createReplyInstance() {
        return new FileConsumeReply();
    }

    @Override
    public void accept(MessageBasedRequestVisitor visitor) {
        ((ProtocolVisitor)visitor).visit(this);
    }

    @Override
    public Message toMessage() throws JMSException {
        TextMessageImpl message = new TextMessageImpl();
        this.fillMessage(message);
        message.setIntProperty("JMS_SWIFTMQ_FT_DUMPID", 2);
        message.setStringProperty(QUEUENAME_PROP, this.queueName);
        message.setIntProperty(REPLYINTERVAL_PROP, this.replyInterval);
        if (this.passwordHexDigest != null) {
            message.setStringProperty(PWDHEXDIGEST_PROP, this.passwordHexDigest);
        }
        message.setText(this.link);
        return message;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[FileConsumeRequest");
        sb.append(", queueName='").append(this.queueName).append('\'');
        sb.append(", passwordHexDigest='").append(this.passwordHexDigest).append('\'');
        sb.append(", link='").append(this.link).append('\'');
        sb.append(", replyInterval='").append(this.replyInterval).append('\'');
        sb.append(']');
        return sb.toString();
    }
}

