/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.filetransfer.protocol.v940;

import com.swiftmq.filetransfer.protocol.MessageBasedReply;
import com.swiftmq.filetransfer.protocol.MessageBasedRequest;
import com.swiftmq.filetransfer.protocol.MessageBasedRequestVisitor;
import com.swiftmq.filetransfer.protocol.v940.FileDeleteReply;
import com.swiftmq.filetransfer.protocol.v940.ProtocolVisitor;
import com.swiftmq.jms.TextMessageImpl;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.TextMessage;

public class FileDeleteRequest
extends MessageBasedRequest {
    public static final String PWDHEXDIGEST_PROP = "JMS_SWIFTMQ_FT_PWDHEXDIGEST";
    String link = null;
    String passwordHexDigest = null;

    public FileDeleteRequest(Message message) throws JMSException {
        super(message);
        if (message.propertyExists(PWDHEXDIGEST_PROP)) {
            this.passwordHexDigest = message.getStringProperty(PWDHEXDIGEST_PROP);
        }
        this.link = ((TextMessage)message).getText();
    }

    public FileDeleteRequest(String link, String passwordHexDigest) {
        this.passwordHexDigest = passwordHexDigest;
        this.link = link;
        this.setReplyRequired(true);
    }

    public String getPasswordHexDigest() {
        return this.passwordHexDigest;
    }

    public void setPasswordHexDigest(String passwordHexDigest) {
        this.passwordHexDigest = passwordHexDigest;
    }

    public String getLink() {
        return this.link;
    }

    public void setLink(String link) {
        this.link = link;
    }

    @Override
    public MessageBasedReply createReplyInstance() {
        return new FileDeleteReply();
    }

    @Override
    public void accept(MessageBasedRequestVisitor visitor) {
        ((ProtocolVisitor)visitor).visit(this);
    }

    @Override
    public Message toMessage() throws JMSException {
        TextMessageImpl message = new TextMessageImpl();
        this.fillMessage(message);
        message.setIntProperty("JMS_SWIFTMQ_FT_DUMPID", 6);
        if (this.passwordHexDigest != null) {
            message.setStringProperty(PWDHEXDIGEST_PROP, this.passwordHexDigest);
        }
        message.setText(this.link);
        return message;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[FileDeleteRequest");
        sb.append(", passwordHexDigest=").append(this.passwordHexDigest);
        sb.append(", link='").append(this.link);
        sb.append(']');
        return sb.toString();
    }
}

