/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.filetransfer.protocol.v940;

import com.swiftmq.filetransfer.protocol.MessageBasedReply;
import com.swiftmq.jms.MessageImpl;
import javax.jms.JMSException;
import javax.jms.Message;

public class FilePublishReply
extends MessageBasedReply {
    public static final String CHUNKLENGTH_PROP = "JMS_SWIFTMQ_FT_CHUNKLENGTH";
    int chunkLength = 0;

    public FilePublishReply(Message message) throws JMSException {
        super(message);
        this.chunkLength = message.getIntProperty(CHUNKLENGTH_PROP);
    }

    public FilePublishReply(int chunkLength) {
        this.chunkLength = chunkLength;
    }

    public FilePublishReply() {
        this(0);
    }

    public int getChunkLength() {
        return this.chunkLength;
    }

    public void setChunkLength(int chunkLength) {
        this.chunkLength = chunkLength;
    }

    @Override
    public Message toMessage() throws JMSException {
        MessageImpl message = new MessageImpl();
        message.setIntProperty("JMS_SWIFTMQ_FT_DUMPID", 1);
        message.setIntProperty(CHUNKLENGTH_PROP, this.chunkLength);
        return this.fillMessage(message);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[FilePublishReply");
        sb.append(super.toString());
        sb.append(", replyInterval=").append(this.chunkLength);
        sb.append(']');
        return sb.toString();
    }
}

