/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.filetransfer.protocol.v940;

import com.swiftmq.filetransfer.protocol.MessageBasedReply;
import com.swiftmq.filetransfer.protocol.MessageBasedRequest;
import com.swiftmq.filetransfer.protocol.MessageBasedRequestVisitor;
import com.swiftmq.filetransfer.protocol.v940.FilePublishReply;
import com.swiftmq.filetransfer.protocol.v940.ProtocolVisitor;
import com.swiftmq.jms.MessageImpl;
import javax.jms.JMSException;
import javax.jms.Message;

public class FilePublishRequest
extends MessageBasedRequest {
    public static final String REPLYQUEUE_PROP = "JMS_SWIFTMQ_FT_REPLYQUEUE";
    public static final String FILENAME_PROP = "JMS_SWIFTMQ_FT_FILENAME";
    public static final String SIZE_PROP = "JMS_SWIFTMQ_FT_SIZE";
    public static final String EXPIRATION_PROP = "JMS_SWIFTMQ_FT_EXPIRATION";
    public static final String DELAFTERDL_PROP = "JMS_SWIFTMQ_FT_DELAFTDL";
    public static final String DIGESTTYPE_PROP = "JMS_SWIFTMQ_FT_DIGESTTYPE";
    public static final String PWDHEXDIGEST_PROP = "JMS_SWIFTMQ_FT_PWDHEXDIGEST";
    public static final String FILEISPRIVATE_PROP = "JMS_SWIFTMQ_FT_FILEISPRIVATE";
    public static final String USERNAME_PROP = "JMS_SWIFTMQ_FT_USERNAME";
    String replyQueue = null;
    String filename = null;
    String username = null;
    long size = 0L;
    long expiration = 0L;
    int deleteAfterNumberDownloads = 0;
    String digestType = null;
    String passwordHexDigest = null;
    boolean fileIsPrivate = false;

    public FilePublishRequest(Message message) throws JMSException {
        super(message);
        this.replyQueue = message.getStringProperty(REPLYQUEUE_PROP);
        this.filename = message.getStringProperty(FILENAME_PROP);
        this.username = message.getStringProperty(USERNAME_PROP);
        this.size = message.getLongProperty(SIZE_PROP);
        this.expiration = message.getLongProperty(EXPIRATION_PROP);
        this.deleteAfterNumberDownloads = message.getIntProperty(DELAFTERDL_PROP);
        this.digestType = message.getStringProperty(DIGESTTYPE_PROP);
        if (message.propertyExists(PWDHEXDIGEST_PROP)) {
            this.passwordHexDigest = message.getStringProperty(PWDHEXDIGEST_PROP);
        }
        this.fileIsPrivate = message.getBooleanProperty(FILEISPRIVATE_PROP);
    }

    public FilePublishRequest(String replyQueue, String filename, String username, long size, long expiration, int deleteAfterNumberDownloads, String digestType, String passwordHexDigest, boolean fileIsPrivate) {
        this.setReplyRequired(true);
        this.replyQueue = replyQueue;
        this.filename = filename;
        this.username = username;
        this.size = size;
        this.expiration = expiration;
        this.deleteAfterNumberDownloads = deleteAfterNumberDownloads;
        this.digestType = digestType;
        this.passwordHexDigest = passwordHexDigest;
        this.fileIsPrivate = fileIsPrivate;
    }

    public String getReplyQueue() {
        return this.replyQueue;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public String getUsername() {
        return this.username;
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public long getExpiration() {
        return this.expiration;
    }

    public void setExpiration(long expiration) {
        this.expiration = expiration;
    }

    public int getDeleteAfterNumberDownloads() {
        return this.deleteAfterNumberDownloads;
    }

    public void setDeleteAfterNumberDownloads(int deleteAfterNumberDownloads) {
        this.deleteAfterNumberDownloads = deleteAfterNumberDownloads;
    }

    public String getDigestType() {
        return this.digestType;
    }

    public void setDigestType(String digestType) {
        this.digestType = digestType;
    }

    public String getPasswordHexDigest() {
        return this.passwordHexDigest;
    }

    public void setPasswordHexDigest(String passwordHexDigest) {
        this.passwordHexDigest = passwordHexDigest;
    }

    public boolean isFileIsPrivate() {
        return this.fileIsPrivate;
    }

    public void setFileIsPrivate(boolean fileIsPrivate) {
        this.fileIsPrivate = fileIsPrivate;
    }

    @Override
    public MessageBasedReply createReplyInstance() {
        return new FilePublishReply();
    }

    @Override
    public void accept(MessageBasedRequestVisitor visitor) {
        ((ProtocolVisitor)visitor).visit(this);
    }

    @Override
    public Message toMessage() throws JMSException {
        MessageImpl message = new MessageImpl();
        this.fillMessage(message);
        message.setIntProperty("JMS_SWIFTMQ_FT_DUMPID", 0);
        message.setStringProperty(REPLYQUEUE_PROP, this.replyQueue);
        message.setStringProperty(FILENAME_PROP, this.filename);
        if (this.username != null) {
            message.setStringProperty(USERNAME_PROP, this.username);
        }
        message.setLongProperty(SIZE_PROP, this.size);
        message.setLongProperty(EXPIRATION_PROP, this.expiration);
        message.setStringProperty(DIGESTTYPE_PROP, this.digestType);
        if (this.passwordHexDigest != null) {
            message.setStringProperty(PWDHEXDIGEST_PROP, this.passwordHexDigest);
        }
        message.setIntProperty(DELAFTERDL_PROP, this.deleteAfterNumberDownloads);
        message.setBooleanProperty(FILEISPRIVATE_PROP, this.fileIsPrivate);
        return message;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[FilePublishRequest");
        sb.append(", replyQueue='").append(this.replyQueue).append('\'');
        sb.append(", filename='").append(this.filename).append('\'');
        sb.append(", username='").append(this.username).append('\'');
        sb.append(", size=").append(this.size);
        sb.append(", expiration=").append(this.expiration);
        sb.append(", deleteAfterNumberDownloads=").append(this.deleteAfterNumberDownloads);
        sb.append(", digestType=").append(this.digestType);
        sb.append(", passwordHexDigest=").append(this.passwordHexDigest);
        sb.append(", fileIsPrivate=").append(this.fileIsPrivate);
        sb.append(']');
        return sb.toString();
    }
}

