/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.filetransfer.protocol.v940;

import com.swiftmq.filetransfer.protocol.MessageBasedReply;
import com.swiftmq.jms.MapMessageImpl;
import java.util.ArrayList;
import java.util.List;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;

public class FileQueryReply
extends MessageBasedReply {
    public static final String RESULTSIZE_PROP = "JMS_SWIFTMQ_FT_RESULTSIZE";
    public static final String RESULT_PROP = "JMS_SWIFTMQ_FT_RESULT_";
    List<String> result = null;

    public FileQueryReply(Message message) throws JMSException {
        super(message);
        this.createResultList((MapMessage)message);
    }

    public FileQueryReply() {
    }

    private void createResultList(MapMessage message) throws JMSException {
        int n = message.getInt(RESULTSIZE_PROP);
        if (n > 0) {
            this.result = new ArrayList<String>(n);
            for (int i = 0; i < n; ++i) {
                this.result.add(message.getString(RESULT_PROP + i));
            }
        }
    }

    public List<String> getResult() {
        return this.result;
    }

    public void setResult(List<String> result) {
        this.result = result;
    }

    @Override
    public Message toMessage() throws JMSException {
        MapMessageImpl message = new MapMessageImpl();
        message.setIntProperty("JMS_SWIFTMQ_FT_DUMPID", 9);
        if (this.result == null) {
            message.setInt(RESULTSIZE_PROP, 0);
        } else {
            message.setInt(RESULTSIZE_PROP, this.result.size());
            for (int i = 0; i < this.result.size(); ++i) {
                message.setString(RESULT_PROP + i, this.result.get(i));
            }
        }
        return this.fillMessage(message);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[FileChunkReply");
        sb.append(super.toString());
        sb.append(" result='").append(this.result).append('\'');
        sb.append(']');
        return sb.toString();
    }
}

