/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.filetransfer.protocol.v940;

import com.swiftmq.filetransfer.protocol.MessageBased;
import com.swiftmq.filetransfer.protocol.MessageBasedFactory;
import com.swiftmq.filetransfer.protocol.v940.FileChunkReply;
import com.swiftmq.filetransfer.protocol.v940.FileChunkRequest;
import com.swiftmq.filetransfer.protocol.v940.FileConsumeReply;
import com.swiftmq.filetransfer.protocol.v940.FileConsumeRequest;
import com.swiftmq.filetransfer.protocol.v940.FileDeleteReply;
import com.swiftmq.filetransfer.protocol.v940.FileDeleteRequest;
import com.swiftmq.filetransfer.protocol.v940.FilePublishReply;
import com.swiftmq.filetransfer.protocol.v940.FilePublishRequest;
import com.swiftmq.filetransfer.protocol.v940.FileQueryReply;
import com.swiftmq.filetransfer.protocol.v940.FileQueryRequest;
import com.swiftmq.filetransfer.protocol.v940.SessionCloseRequest;
import javax.jms.JMSException;
import javax.jms.Message;

public class ProtocolFactory
implements MessageBasedFactory {
    public static final String DUMPID_PROP = "JMS_SWIFTMQ_FT_DUMPID";
    public static final int FILEPUBLISH_REQ = 0;
    public static final int FILEPUBLISH_REP = 1;
    public static final int FILECONSUME_REQ = 2;
    public static final int FILECONSUME_REP = 3;
    public static final int FILECHUNK_REQ = 4;
    public static final int FILECHUNK_REP = 5;
    public static final int FILEDELETE_REQ = 6;
    public static final int FILEDELETE_REP = 7;
    public static final int FILEQUERY_REQ = 8;
    public static final int FILEQUERY_REP = 9;
    public static final int SESSIONCLOSE_REQ = 10;
    MessageBasedFactory delegatedFactory = null;

    public ProtocolFactory() {
    }

    public ProtocolFactory(MessageBasedFactory delegatedFactory) {
        this.delegatedFactory = delegatedFactory;
    }

    public void setDelegatedFactory(MessageBasedFactory delegatedFactory) {
        this.delegatedFactory = delegatedFactory;
    }

    @Override
    public MessageBased create(Message message) throws JMSException {
        MessageBased messageBased = null;
        int dumpId = message.getIntProperty(DUMPID_PROP);
        switch (dumpId) {
            case 0: {
                messageBased = new FilePublishRequest(message);
                break;
            }
            case 1: {
                messageBased = new FilePublishReply(message);
                break;
            }
            case 2: {
                messageBased = new FileConsumeRequest(message);
                break;
            }
            case 3: {
                messageBased = new FileConsumeReply(message);
                break;
            }
            case 4: {
                messageBased = new FileChunkRequest(message);
                break;
            }
            case 5: {
                messageBased = new FileChunkReply(message);
                break;
            }
            case 6: {
                messageBased = new FileDeleteRequest(message);
                break;
            }
            case 7: {
                messageBased = new FileDeleteReply(message);
                break;
            }
            case 8: {
                messageBased = new FileQueryRequest(message);
                break;
            }
            case 9: {
                messageBased = new FileQueryReply(message);
                break;
            }
            case 10: {
                messageBased = new SessionCloseRequest(message);
                break;
            }
            default: {
                if (this.delegatedFactory == null) break;
                messageBased = this.delegatedFactory.create(message);
            }
        }
        return messageBased;
    }
}

