/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.filetransfer.protocol.v941;

import com.swiftmq.filetransfer.protocol.MessageBasedReply;
import com.swiftmq.jms.TextMessageImpl;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.Dom4JDriver;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.TextMessage;

public class FileQueryPropsReply
extends MessageBasedReply {
    Map<String, Map<String, Object>> result = null;

    public FileQueryPropsReply(Message message) throws JMSException {
        super(message);
        this.createResult((TextMessage)message);
    }

    public FileQueryPropsReply() {
    }

    private void createResult(TextMessage message) throws JMSException {
        String s = message.getText();
        if (s != null) {
            XStream xStream = new XStream((HierarchicalStreamDriver)new Dom4JDriver());
            StringReader reader = new StringReader(s);
            this.result = (Map)xStream.fromXML((Reader)reader);
        }
    }

    public Map<String, Map<String, Object>> getResult() {
        return this.result;
    }

    public void setResult(Map<String, Map<String, Object>> result) {
        this.result = result;
    }

    @Override
    public Message toMessage() throws JMSException {
        TextMessageImpl message = new TextMessageImpl();
        message.setIntProperty("JMS_SWIFTMQ_FT_DUMPID", 12);
        if (this.result != null && this.result.size() > 0) {
            XStream xStream = new XStream((HierarchicalStreamDriver)new Dom4JDriver());
            StringWriter writer = new StringWriter();
            xStream.toXML(this.result, (Writer)writer);
            message.setText(writer.toString());
        }
        return this.fillMessage(message);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[FileQueryPropsReply");
        sb.append(super.toString());
        sb.append(" result='").append(this.result).append('\'');
        sb.append(']');
        return sb.toString();
    }
}

