/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.filetransfer.protocol.v941;

import com.swiftmq.filetransfer.protocol.MessageBasedReply;
import com.swiftmq.filetransfer.protocol.MessageBasedRequest;
import com.swiftmq.filetransfer.protocol.MessageBasedRequestVisitor;
import com.swiftmq.filetransfer.protocol.v941.FileQueryPropsReply;
import com.swiftmq.filetransfer.protocol.v941.ProtocolVisitor;
import com.swiftmq.jms.TextMessageImpl;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.TextMessage;

public class FileQueryPropsRequest
extends MessageBasedRequest {
    public static final String LINK_PROP = "JMS_SWIFTMQ_FT_LINK";
    String link = null;
    String selector = null;

    public FileQueryPropsRequest(Message message) throws JMSException {
        super(message);
        this.link = message.getStringProperty(LINK_PROP);
        this.selector = ((TextMessage)message).getText();
    }

    public FileQueryPropsRequest(String link, String selector) {
        this.link = link;
        this.selector = selector;
        this.setReplyRequired(true);
    }

    public String getLink() {
        return this.link;
    }

    public void setLink(String link) {
        this.link = link;
    }

    public String getSelector() {
        return this.selector;
    }

    public void setSelector(String selector) {
        this.selector = selector;
    }

    @Override
    public MessageBasedReply createReplyInstance() {
        return new FileQueryPropsReply();
    }

    @Override
    public void accept(MessageBasedRequestVisitor visitor) {
        ((ProtocolVisitor)visitor).visit(this);
    }

    @Override
    public Message toMessage() throws JMSException {
        TextMessageImpl message = new TextMessageImpl();
        message.setIntProperty("JMS_SWIFTMQ_FT_DUMPID", 11);
        if (this.link != null) {
            message.setStringProperty(LINK_PROP, this.link);
        }
        this.fillMessage(message);
        message.setText(this.selector);
        return message;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[FileQueryPropsRequest");
        sb.append(", link='").append(this.link);
        sb.append(", selector='").append(this.selector);
        sb.append(']');
        return sb.toString();
    }
}

