/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.filetransfer.protocol.v941;

import com.swiftmq.filetransfer.protocol.MessageBasedReply;
import com.swiftmq.filetransfer.protocol.MessageBasedRequest;
import com.swiftmq.filetransfer.protocol.MessageBasedRequestVisitor;
import com.swiftmq.filetransfer.protocol.v941.FileQueryReply;
import com.swiftmq.filetransfer.protocol.v941.ProtocolVisitor;
import com.swiftmq.jms.TextMessageImpl;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.TextMessage;

public class FileQueryRequest
extends MessageBasedRequest {
    String selector = null;

    public FileQueryRequest(Message message) throws JMSException {
        super(message);
        this.selector = ((TextMessage)message).getText();
    }

    public FileQueryRequest(String selector) {
        this.selector = selector;
        this.setReplyRequired(true);
    }

    public String getSelector() {
        return this.selector;
    }

    public void setSelector(String selector) {
        this.selector = selector;
    }

    @Override
    public MessageBasedReply createReplyInstance() {
        return new FileQueryReply();
    }

    @Override
    public void accept(MessageBasedRequestVisitor visitor) {
        ((ProtocolVisitor)visitor).visit(this);
    }

    @Override
    public Message toMessage() throws JMSException {
        TextMessageImpl message = new TextMessageImpl();
        message.setIntProperty("JMS_SWIFTMQ_FT_DUMPID", 8);
        this.fillMessage(message);
        message.setText(this.selector);
        return message;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[FileQueryRequest");
        sb.append(", selector='").append(this.selector);
        sb.append(']');
        return sb.toString();
    }
}

