/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.filetransfer.test;

import com.swiftmq.filetransfer.Filetransfer;
import java.io.File;
import java.util.Hashtable;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.naming.InitialContext;

public class FileQueryReceiver {
    static Connection connection = null;
    static File outDir = null;
    static ExecutorService executorService = Executors.newFixedThreadPool(5);
    static CountDownLatch countDownLatch = null;

    private static void transfer(String link) throws Exception {
        System.out.println("Transferring: " + link);
        Filetransfer filetransfer = Filetransfer.create(connection, link).withDigestType("MD5");
        filetransfer.withOriginalFilename(true).withOutputDirectory(outDir).withPassword("Cheers").receive((filename, chunksTransferred, fileSize, bytesTransferred, transferredPercent) -> System.out.println("  " + filename + ": " + chunksTransferred + " chunks, " + bytesTransferred + " of " + fileSize + " transferred (" + transferredPercent + "%)")).delete().close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        if (args.length != 5) {
            System.out.println("Usage: FileReceiver <smqp-url> <connection-factory> <routername> <cachename> <output-dir>");
            System.exit(-1);
        }
        try {
            Filetransfer filetransfer;
            List<String> result;
            Hashtable<String, String> env = new Hashtable<String, String>();
            env.put("java.naming.factory.initial", "com.swiftmq.jndi.InitialContextFactoryImpl");
            env.put("java.naming.provider.url", args[0]);
            InitialContext ctx = new InitialContext(env);
            ConnectionFactory cf = (ConnectionFactory)ctx.lookup(args[1]);
            ctx.close();
            connection = cf.createConnection();
            connection.start();
            outDir = new File(args[4]);
            if (!outDir.exists()) {
                outDir.mkdirs();
            }
            if ((result = (filetransfer = Filetransfer.create(connection, args[2], args[3]).withSelector(null)).query()) != null && result.size() > 0) {
                countDownLatch = new CountDownLatch(result.size());
                for (String link : result) {
                    executorService.execute(() -> {
                        try {
                            FileQueryReceiver.transfer(link);
                            countDownLatch.countDown();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    });
                }
            }
            filetransfer.close();
            if (countDownLatch != null) {
                countDownLatch.await();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            executorService.shutdown();
            try {
                connection.close();
            }
            catch (JMSException jMSException) {}
        }
    }
}

