/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.filetransfer.test;

import com.swiftmq.filetransfer.Filetransfer;
import java.io.File;
import java.util.Hashtable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.naming.InitialContext;

public class FileReceiver {
    static Connection connection = null;
    static File outDir = null;
    static ExecutorService executorService = Executors.newFixedThreadPool(5);

    private static void transfer(String link) throws Exception {
        System.out.println("Transferring: " + link);
        Filetransfer filetransfer = Filetransfer.create(connection, link).withDigestType("MD5");
        filetransfer.withOriginalFilename(true).withOutputDirectory(outDir).withPassword("Moin!").receive((filename, chunksTransferred, fileSize, bytesTransferred, transferredPercent) -> System.out.println("  " + filename + ": " + chunksTransferred + " chunks, " + bytesTransferred + " of " + fileSize + " transferred (" + transferredPercent + "%)")).delete().close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        if (args.length != 4) {
            System.out.println("Usage: FileReceiver <smqp-url> <connection-factory> <link-input-dest> <output-dir>");
            System.exit(-1);
        }
        try {
            Hashtable<String, String> env = new Hashtable<String, String>();
            env.put("java.naming.factory.initial", "com.swiftmq.jndi.InitialContextFactoryImpl");
            env.put("java.naming.provider.url", args[0]);
            InitialContext ctx = new InitialContext(env);
            ConnectionFactory cf = (ConnectionFactory)ctx.lookup(args[1]);
            Destination linkInputDest = (Destination)ctx.lookup(args[2]);
            ctx.close();
            connection = cf.createConnection();
            connection.start();
            outDir = new File(args[3]);
            if (!outDir.exists()) {
                outDir.mkdirs();
            }
            Session session = connection.createSession(false, 1);
            MessageConsumer consumer = session.createConsumer(linkInputDest);
            TextMessage msg = null;
            while ((msg = (TextMessage)consumer.receive()) != null) {
                String link = msg.getText();
                executorService.execute(() -> {
                    try {
                        FileReceiver.transfer(link);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                });
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            executorService.shutdown();
            try {
                connection.close();
            }
            catch (JMSException jMSException) {}
        }
    }
}

